/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import org.betterx.bclib.behaviours.interfaces.BehaviourWaterPlantSeed;
import org.betterx.bclib.blocks.UnderwaterPlantWithAgeBlock;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.blocks.EndLilyBlock;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.wover.block.api.BlockProperties;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class EndLilySeedBlock
extends UnderwaterPlantWithAgeBlock
implements BehaviourWaterPlantSeed {
    public void grow(WorldGenLevel world, RandomSource random, BlockPos pos) {
        if (this.canGrow(world, pos)) {
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)EndBlocks.END_LILY.defaultBlockState().setValue(EndLilyBlock.SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM)));
            BlockPos up = pos.above();
            while (world.getFluidState(up).isSource()) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)up, (BlockState)((BlockState)EndBlocks.END_LILY.defaultBlockState().setValue(EndLilyBlock.SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE)));
                up = up.above();
            }
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)up, (BlockState)((BlockState)EndBlocks.END_LILY.defaultBlockState().setValue(EndLilyBlock.SHAPE, (Comparable)BlockProperties.TripleShape.TOP)));
        }
    }

    private boolean canGrow(WorldGenLevel world, BlockPos pos) {
        BlockPos up = pos.above();
        while (world.getBlockState(up).getFluidState().getType().equals(Fluids.WATER.getSource())) {
            up = up.above();
        }
        return world.isEmptyBlock(up);
    }

    protected boolean isTerrain(BlockState state) {
        return state.is(CommonBlockTags.END_STONES);
    }
}

