/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.behaviours.interfaces.BehaviourWaterPlant;
import org.betterx.bclib.interfaces.tools.AddMineableShears;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.blocks.basis.EndUnderwaterPlantBlock;
import org.betterx.betterend.interfaces.survives.SurvivesOnEndStone;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndItems;
import org.betterx.wover.block.api.BlockProperties;

public class EndLilyBlock
extends EndUnderwaterPlantBlock
implements BehaviourWaterPlant,
AddMineableShears,
SurvivesOnEndStone {
    public static final EnumProperty<BlockProperties.TripleShape> SHAPE = BlockProperties.TRIPLE_SHAPE;
    private static final VoxelShape SHAPE_BOTTOM = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape SHAPE_TOP = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);

    public EndLilyBlock() {
        super(BehaviourBuilders.createWaterPlant().lightLevel(state -> state.getValue(SHAPE) == BlockProperties.TripleShape.TOP ? 13 : 0));
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            return state.getValue(SHAPE) == BlockProperties.TripleShape.TOP ? Blocks.AIR.defaultBlockState() : Blocks.WATER.defaultBlockState();
        }
        return state;
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        Vec3 vec3d = state.getOffset(view, pos);
        VoxelShape shape = state.getValue(SHAPE) == BlockProperties.TripleShape.TOP ? SHAPE_TOP : SHAPE_BOTTOM;
        return shape.move(vec3d.x, vec3d.y, vec3d.z);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{SHAPE});
    }

    public FluidState getFluidState(BlockState state) {
        return state.getValue(SHAPE) == BlockProperties.TripleShape.TOP ? Fluids.EMPTY.defaultFluidState() : Fluids.WATER.getSource(false);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (state.getValue(SHAPE) == BlockProperties.TripleShape.TOP) {
            return world.getBlockState(pos.below()).getBlock() == this;
        }
        if (state.getValue(SHAPE) == BlockProperties.TripleShape.BOTTOM) {
            return this.isTerrain(world.getBlockState(pos.below()));
        }
        BlockState up = world.getBlockState(pos.above());
        BlockState down = world.getBlockState(pos.below());
        return up.getBlock() == this && down.getBlock() == this;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        if (state.getValue(SHAPE) == BlockProperties.TripleShape.TOP) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)EndItems.END_LILY_LEAF, MHelper.randRange((int)1, (int)2, (RandomSource)MHelper.RANDOM_SOURCE)), new ItemStack((ItemLike)EndBlocks.END_LILY_SEED, MHelper.randRange((int)1, (int)2, (RandomSource)MHelper.RANDOM_SOURCE))});
        }
        return Collections.emptyList();
    }

    public ItemStack getCloneItemStack(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return new ItemStack((ItemLike)EndBlocks.END_LILY_SEED);
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return false;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return false;
    }

    public boolean isTerrain(BlockState state) {
        return SurvivesOnEndStone.super.isTerrain(state);
    }
}

