/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.behaviours.interfaces.BehaviourPlant;
import org.betterx.betterend.blocks.basis.EndPlantWithAgeBlock;
import org.betterx.betterend.interfaces.survives.SurvivesOnEndStone;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.wover.block.api.BlockProperties;

public class CavePumpkinVineBlock
extends EndPlantWithAgeBlock
implements SurvivesOnEndStone,
BehaviourPlant {
    private static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public CavePumpkinVineBlock() {
        super(BehaviourBuilders.createPlant((MapColor)MapColor.TERRACOTTA_ORANGE));
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return this.canSurviveOnBottom(world, pos);
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        int age = (Integer)state.getValue((Property)AGE);
        BlockState down = world.getBlockState(pos.below());
        if (down.canBeReplaced() || down.is(EndBlocks.CAVE_PUMPKIN) && ((Boolean)down.getValue((Property)BlockProperties.SMALL)).booleanValue()) {
            if (age < 3) {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
            }
            if (age == 2) {
                world.setBlockAndUpdate(pos.below(), (BlockState)EndBlocks.CAVE_PUMPKIN.defaultBlockState().setValue((Property)BlockProperties.SMALL, (Comparable)Boolean.valueOf(true)));
            } else if (age == 3) {
                world.setBlockAndUpdate(pos.below(), EndBlocks.CAVE_PUMPKIN.defaultBlockState());
            }
        }
    }

    public void growAdult(WorldGenLevel world, RandomSource random, BlockPos pos) {
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        BlockState down;
        if ((state = super.updateShape(state, facing, neighborState, world, pos, neighborPos)).is((Block)this) && (Integer)state.getValue((Property)BlockProperties.AGE) > 1 && !(down = world.getBlockState(pos.below())).is(EndBlocks.CAVE_PUMPKIN)) {
            state = (BlockState)state.setValue((Property)BlockProperties.AGE, (Comparable)Integer.valueOf(1));
        }
        return state;
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE;
    }

    public boolean isTerrain(BlockState state) {
        return SurvivesOnEndStone.super.isTerrain(state);
    }
}

