/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.client.models.BCLModels;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.blocks.basis.EndLanternBlock;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;

public class BulbVineLanternBlock
extends EndLanternBlock
implements RenderLayerProvider,
BehaviourMetal {
    private static final VoxelShape SHAPE_CEIL = Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape SHAPE_FLOOR = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);

    public BulbVineLanternBlock() {
        this(BehaviourBuilders.createMetal((MapColor)MapColor.COLOR_LIGHT_GRAY).strength(1.0f).lightLevel(bs -> 15).requiresCorrectToolForDrops().sound(SoundType.LANTERN));
    }

    public BulbVineLanternBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return (Boolean)state.getValue((Property)IS_FLOOR) != false ? SHAPE_FLOOR : SHAPE_CEIL;
    }

    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    protected String getMetalTexture(ResourceLocation blockId) {
        String name = blockId.getPath();
        name = name.substring(0, name.indexOf(95));
        return name + "_bulb_vine_lantern_metal";
    }

    protected String getGlowTexture() {
        return "bulb_vine_lantern_bulb";
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)this);
        TextureMapping mapping = new TextureMapping().put(BCLModels.GLOW, BetterEnd.C.mk("bulb_vine_lantern_bulb").withPrefix("block/")).put(BCLModels.METAL, BetterEnd.C.mk(this.getMetalTexture(id)).withPrefix("block/"));
        ResourceLocation floorModel = BCLModels.BULB_LANTERN_FLOOR.createWithSuffix((Block)this, "_floor", mapping, generator.modelOutput());
        ResourceLocation ceilModel = BCLModels.BULB_LANTERN_CEIL.create((Block)this, mapping, generator.modelOutput());
        generator.acceptBlockState((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)this).with((PropertyDispatch)PropertyDispatch.property((Property)IS_FLOOR).select((Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)floorModel)).select((Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)ceilModel))));
    }
}

