/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.behaviours.interfaces.BehaviourGlass;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.blocks.SmaragdantCrystalShardBlock;
import org.betterx.betterend.blocks.basis.LitPillarBlock;
import org.betterx.betterend.registry.EndBlocks;

public class BuddingSmaragdantCrystalBlock
extends LitPillarBlock
implements BehaviourGlass {
    public BuddingSmaragdantCrystalBlock() {
        super(BehaviourBuilders.createGlass().lightLevel(bs -> 15).strength(1.0f).noOcclusion().sound(SoundType.AMETHYST).randomTicks().pushReaction(PushReaction.DESTROY));
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return Collections.emptyList();
    }

    public void randomTick(BlockState blockState, ServerLevel world, BlockPos pos, RandomSource random) {
        Direction dir = BlocksHelper.randomDirection((RandomSource)random);
        BlockPos side = pos.relative(dir);
        BlockState sideState = world.getBlockState(side);
        if (random.nextInt(20) == 0 && BuddingSmaragdantCrystalBlock.canShardGrowAtState(sideState)) {
            BlockState shard = (BlockState)((BlockState)EndBlocks.SMARAGDANT_CRYSTAL_SHARD.defaultBlockState().setValue((Property)SmaragdantCrystalShardBlock.WATERLOGGED, (Comparable)Boolean.valueOf(sideState.getFluidState().getType() == Fluids.WATER))).setValue((Property)SmaragdantCrystalShardBlock.FACING, (Comparable)dir);
            world.setBlockAndUpdate(side, shard);
        }
    }

    public static boolean canShardGrowAtState(BlockState blockState) {
        return blockState.isAir() || blockState.is(Blocks.WATER) && blockState.getFluidState().getAmount() == 8;
    }
}

