/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.CustomColorProvider;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.interfaces.tools.AddMineableHammer;
import org.betterx.bclib.interfaces.tools.AddMineablePickaxe;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.registry.EndItems;
import org.betterx.ui.ColorUtil;
import org.betterx.wover.loot.api.BlockLootProvider;
import org.betterx.wover.loot.api.LootLookupProvider;
import org.jetbrains.annotations.NotNull;

public class AuroraCrystalBlock
extends TransparentBlock
implements BlockLootProvider,
RenderLayerProvider,
CustomColorProvider,
AddMineablePickaxe,
AddMineableHammer {
    public static final Vec3i[] COLORS = new Vec3i[]{new Vec3i(247, 77, 161), new Vec3i(120, 184, 255), new Vec3i(120, 255, 168), new Vec3i(243, 58, 255)};
    private static final int MIN_DROP = 1;
    private static final int MAX_DROP = 4;

    public AuroraCrystalBlock() {
        super(BehaviourBuilders.createGlass().strength(1.0f).lightLevel(bs -> 15));
    }

    @Deprecated
    public VoxelShape getVisualShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return this.getCollisionShape(blockState, blockGetter, blockPos, collisionContext);
    }

    public BlockColor getProvider() {
        return (state, world, pos, tintIndex) -> {
            if (pos == null) {
                pos = BlockPos.ZERO;
            }
            long i = (long)pos.getX() + (long)pos.getY() + (long)pos.getZ();
            double delta = (double)i * 0.1;
            int index = MHelper.floor((double)delta);
            int index2 = index + 1 & 3;
            delta -= (double)index;
            Vec3i color1 = COLORS[index &= 3];
            Vec3i color2 = COLORS[index2];
            int r = MHelper.floor((double)Mth.lerp((double)delta, (double)color1.getX(), (double)color2.getX()));
            int g = MHelper.floor((double)Mth.lerp((double)delta, (double)color1.getY(), (double)color2.getY()));
            int b = MHelper.floor((double)Mth.lerp((double)delta, (double)color1.getZ(), (double)color2.getZ()));
            return ColorUtil.color((int)r, (int)g, (int)b);
        };
    }

    public ItemColor getItemProvider() {
        return (stack, tintIndex) -> ColorUtil.color((int)COLORS[3].getX(), (int)COLORS[3].getY(), (int)COLORS[3].getZ());
    }

    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.TRANSLUCENT;
    }

    public LootTable.Builder registerBlockLoot(@NotNull ResourceLocation location, @NotNull LootLookupProvider provider, @NotNull ResourceKey<LootTable> tableKey) {
        return provider.dropOre((Block)this, EndItems.CRYSTAL_SHARDS, (NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f));
    }
}

