/*
 * Decompiled with CFR 0.152.
 */
package cubicoder.well.item;

import cubicoder.well.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class ColoredWellBlockItem
extends BlockItem {
    public ColoredWellBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockState state = level.getBlockState(context.getClickedPos());
        if (state.getBlock() instanceof LayeredCauldronBlock) {
            int cauldronLevel;
            if (!level.isClientSide && !player.isCreative() && (cauldronLevel = ((Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL)).intValue()) > 0) {
                player.getItemInHand(context.getHand()).shrink(1);
                player.awardStat(Stats.USE_CAULDRON);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.WELL.get()));
                LayeredCauldronBlock.lowerFillLevel((BlockState)state, (Level)level, (BlockPos)context.getClickedPos());
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }
}

