/*
 * Decompiled with CFR 0.152.
 */
package cubicoder.well.data.client;

import cubicoder.well.block.ModBlocks;
import cubicoder.well.block.WellBlock;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModBlockStateProvider
extends BlockStateProvider {
    private ModelFile.ExistingModelFile wellBase;

    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "well", exFileHelper);
        this.wellBase = new ModelFile.ExistingModelFile(this.modLoc("block/well_base"), exFileHelper);
    }

    protected void registerStatesAndModels() {
        ModBlocks.BLOCKS.getEntries().forEach(block -> {
            this.wellBlockRoof((Block)block.get());
            this.wellItemModel((Block)block.get());
            this.wellBlockState((Block)block.get());
        });
    }

    private BlockModelBuilder wellBlockRoof(Block block) {
        String path = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        String color = path.length() > 4 ? path.substring(0, path.length() - 5) : "brick";
        return (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(path + "_roof", this.modLoc("block/template_well_roof"))).texture("roof", this.modLoc("block/" + color + "_roof"));
    }

    private ItemModelBuilder wellItemModel(Block block) {
        String path = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        String color = path.length() > 4 ? path.substring(0, path.length() - 5) : "brick";
        return (ItemModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent(path, this.modLoc("block/template_well"))).texture("roof", this.modLoc("block/" + color + "_roof"));
    }

    private VariantBlockStateBuilder wellBlockState(Block block) {
        String path = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        String color = path.length() > 4 ? path.substring(0, path.length() - 5) + "_" : "";
        ModelFile.UncheckedModelFile wellRoof = new ModelFile.UncheckedModelFile(this.modLoc("block/" + color + "well_roof"));
        return this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)(((DoubleBlockHalf)state.getValue(WellBlock.HALF)).equals((Object)DoubleBlockHalf.LOWER) ? this.wellBase : wellRoof)).rotationY(((Direction.Axis)state.getValue(WellBlock.AXIS)).equals((Object)Direction.Axis.X) ? 0 : 90).rotationX((Boolean)state.getValue((Property)WellBlock.UPSIDE_DOWN) != false ? 180 : 0).build());
    }
}

