/*
 * Decompiled with CFR 0.152.
 */
package cubicoder.well.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;

public class WellData {
    public static final WellData REGULAR_DEFAULT = new WellData(new FluidStack((Fluid)Fluids.WATER, 1000), 160, 200);
    public static final WellData UPSIDE_DEFAULT = new WellData(new FluidStack((Fluid)Fluids.WATER, 1000), 160, 200);
    public FluidStack fluid;
    public int minToFill;
    public int maxToFill;
    public List<ResourceLocation> biomes;
    public List<ResourceLocation> biomeTags;

    public WellData(FluidStack fluid, int minToFill, int maxToFill, List<ResourceLocation> biomes, List<ResourceLocation> biomeTags) {
        this.fluid = fluid;
        this.minToFill = minToFill;
        this.maxToFill = maxToFill;
        this.biomes = biomes;
        this.biomeTags = biomeTags;
    }

    public WellData(FluidStack fluid, int minToFill, int maxToFill) {
        this.fluid = fluid;
        this.minToFill = minToFill;
        this.maxToFill = maxToFill;
        this.biomes = new ArrayList<ResourceLocation>();
        this.biomeTags = new ArrayList<ResourceLocation>();
    }

    public boolean hasBiome(Biome biome, Level level) {
        Registry reg = level.registryAccess().registryOrThrow(Registries.BIOME);
        ResourceLocation biomeName = reg.getKey((Object)biome);
        for (ResourceLocation loc : this.biomes) {
            if (!biomeName.equals((Object)loc)) continue;
            return true;
        }
        for (ResourceLocation tag : this.biomeTags) {
            for (Holder b : reg.getOrCreateTag(TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)tag))) {
                if (!biomeName.equals((Object)reg.getKey((Object)((Biome)b.value())))) continue;
                return true;
            }
        }
        return false;
    }

    public void resetToDefault() {
        this.fluid = new FluidStack((Fluid)Fluids.WATER, 1000);
        this.minToFill = 160;
        this.maxToFill = 200;
    }
}

