/*
 * Decompiled with CFR 0.152.
 */
package cubicoder.well.config;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import cubicoder.well.config.WellData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.fluids.FluidStack;

public class WellConfig {
    public static final ModConfigSpec CLIENT_CONFIG = WellConfig.clientConfig(new ModConfigSpec.Builder());
    public static final ModConfigSpec SERVER_CONFIG = WellConfig.serverConfig(new ModConfigSpec.Builder());
    public static ModConfigSpec.IntValue tankCapacity;
    public static ModConfigSpec.BooleanValue onlyOnePerChunk;
    public static ModConfigSpec.BooleanValue playSound;
    public static ModConfigSpec.ConfigValue<List<? extends String>> dataList;
    private static final List<WellData> regularWellDataList;
    private static final List<WellData> upsideWellDataList;

    public static void init(ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_CONFIG);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG);
    }

    private static ModConfigSpec clientConfig(ModConfigSpec.Builder builder) {
        playSound = builder.comment("Play the well cranking sound when someone takes fluid from a well.").translation("config.well.playSound").define("playSound", true);
        return builder.build();
    }

    private static ModConfigSpec serverConfig(ModConfigSpec.Builder builder) {
        tankCapacity = builder.comment("How many millibuckets of a fluid can wells hold? Set to 0 to disable.").translation("config.well.tankCapacity").worldRestart().defineInRange("tankCapacity", 100000, 0, Integer.MAX_VALUE);
        onlyOnePerChunk = builder.comment("When set to true, all wells in the chunk will stop working while there's more than 1.").translation("config.well.onlyOnePerChunk").define("onlyOnePerChunk", false);
        dataList = builder.comment("Handle what fluids wells collect based on biome, and how much").translation("config.well.data").defineListAllowEmpty(List.of("dataList"), () -> List.of("{}"), WellConfig::validateData);
        return builder.build();
    }

    public static boolean validateData(Object entry) {
        if (!(entry instanceof String)) {
            return false;
        }
        try {
            TagParser.parseTag((String)((String)entry));
            return true;
        }
        catch (CommandSyntaxException e) {
            return false;
        }
    }

    public static FluidStack loadFluidStackFromNBT(CompoundTag nbt) {
        if (nbt == null) {
            return FluidStack.EMPTY;
        }
        if (!nbt.contains("FluidName", 8)) {
            return FluidStack.EMPTY;
        }
        ResourceLocation fluidName = ResourceLocation.parse((String)nbt.getString("FluidName"));
        Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(fluidName);
        if (fluid == Fluids.EMPTY) {
            return FluidStack.EMPTY;
        }
        FluidStack stack = new FluidStack(fluid, nbt.getInt("Amount"));
        return stack;
    }

    public static void initData(String entry) {
        try {
            CompoundTag data = TagParser.parseTag((String)entry);
            if (data.contains("Fluid", 10)) {
                int minToFill;
                FluidStack fluid = WellConfig.loadFluidStackFromNBT(data.getCompound("Fluid"));
                if (fluid == null) {
                    return;
                }
                boolean isUpsideDown = fluid.getFluid().getFluidType().isLighterThanAir();
                int n = data.contains("MinTicks", 3) ? Math.abs(data.getInt("MinTicks")) : (minToFill = (isUpsideDown ? WellData.UPSIDE_DEFAULT : WellData.REGULAR_DEFAULT).minToFill);
                int maxToFill = data.contains("MaxTicks", 3) ? Math.abs(data.getInt("MaxTicks")) : (isUpsideDown ? WellData.UPSIDE_DEFAULT : WellData.REGULAR_DEFAULT).maxToFill;
                ArrayList<ResourceLocation> biomes = new ArrayList<ResourceLocation>();
                data.getList("Biomes", 8).forEach(biomeNbt -> biomes.add(ResourceLocation.parse((String)biomeNbt.getAsString())));
                ArrayList<ResourceLocation> biomeTags = new ArrayList<ResourceLocation>();
                data.getList("BiomeTags", 8).forEach(biomeTagNbt -> biomeTags.add(ResourceLocation.parse((String)biomeTagNbt.getAsString())));
                if (biomes.isEmpty() && biomeTags.isEmpty()) {
                    WellData wellData = new WellData(fluid, minToFill, maxToFill);
                    if (isUpsideDown) {
                        WellData.UPSIDE_DEFAULT.fluid = wellData.fluid;
                        WellData.UPSIDE_DEFAULT.minToFill = wellData.minToFill;
                        WellData.UPSIDE_DEFAULT.maxToFill = wellData.maxToFill;
                    } else {
                        WellData.REGULAR_DEFAULT.fluid = wellData.fluid;
                        WellData.REGULAR_DEFAULT.minToFill = wellData.minToFill;
                        WellData.REGULAR_DEFAULT.maxToFill = wellData.maxToFill;
                    }
                } else {
                    WellData wellData = new WellData(fluid, minToFill, maxToFill, biomes, biomeTags);
                    if (isUpsideDown) {
                        upsideWellDataList.add(wellData);
                    } else {
                        regularWellDataList.add(wellData);
                    }
                }
            }
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
    }

    public static boolean canGenerateFluid(int nearbyWells) {
        return (Boolean)onlyOnePerChunk.get() == false || nearbyWells == 1;
    }

    public static FluidStack getFillFluid(Biome biome, Level level, BlockPos pos, boolean upsideDown, int nearbyWells) {
        WellData data = WellConfig.getWellDataForBiome(biome, level, upsideDown);
        FluidStack fluid = data.fluid.copy();
        return fluid;
    }

    public static int getFillDelay(Biome biome, Level level, RandomSource random, boolean upsideDown) {
        WellData data = WellConfig.getWellDataForBiome(biome, level, upsideDown);
        return data.maxToFill == data.minToFill ? data.maxToFill : random.nextInt(data.minToFill, data.maxToFill);
    }

    private static WellData getWellDataForBiome(Biome biome, Level level, boolean upsideDown) {
        for (WellData wellData : upsideDown ? upsideWellDataList : regularWellDataList) {
            if (!wellData.hasBiome(biome, level)) continue;
            return wellData;
        }
        return upsideDown ? WellData.UPSIDE_DEFAULT : WellData.REGULAR_DEFAULT;
    }

    public static void configChanged(ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            WellData.REGULAR_DEFAULT.resetToDefault();
            WellData.UPSIDE_DEFAULT.resetToDefault();
            regularWellDataList.clear();
            upsideWellDataList.clear();
            ((List)dataList.get()).forEach(entry -> WellConfig.initData(entry));
        }
    }

    static {
        regularWellDataList = new ArrayList<WellData>();
        upsideWellDataList = new ArrayList<WellData>();
    }
}

