/*
 * Decompiled with CFR 0.152.
 */
package cubicoder.well.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import cubicoder.well.block.WellBlock;
import cubicoder.well.block.entity.WellBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix4f;

public class WellRenderer
implements BlockEntityRenderer<WellBlockEntity> {
    public WellRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(WellBlockEntity well, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        FluidStack fluidStack = well.getTank().getFluid();
        if (!fluidStack.isEmpty()) {
            int amount = fluidStack.getAmount();
            int capacity = well.getTank().getCapacity();
            boolean upsideDown = well.isUpsideDown();
            Fluid fluid = fluidStack.getFluid();
            IClientFluidTypeExtensions fluidEx = IClientFluidTypeExtensions.of((Fluid)fluid);
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(fluidEx.getStillTexture(fluidStack));
            Level level = well.getLevel();
            BlockPos pos = well.getBlockPos();
            int color = fluidEx.getTintColor(fluid.getFluidType().getStateForPlacement((BlockAndTintGetter)level, pos, fluidStack), (BlockAndTintGetter)level, pos);
            float corner = 0.1875f;
            float height = WellBlock.getFluidRenderHeight(amount, capacity, upsideDown);
            float minU = sprite.getU(0.1875f);
            float maxU = sprite.getU(0.8125f);
            float minV = sprite.getV(0.1875f);
            float maxV = sprite.getV(0.8125f);
            VertexConsumer builder = bufferSource.getBuffer(RenderType.translucent());
            Matrix4f matrix = poseStack.last().pose();
            if (upsideDown) {
                builder.addVertex(matrix, 1.0f - corner, height, corner).setColor(color).setUv(maxU, minV).setLight(packedLight).setNormal(0.0f, -1.0f, 0.0f);
                builder.addVertex(matrix, 1.0f - corner, height, 1.0f - corner).setColor(color).setUv(maxU, maxV).setLight(packedLight).setNormal(0.0f, -1.0f, 0.0f);
                builder.addVertex(matrix, corner, height, 1.0f - corner).setColor(color).setUv(minU, maxV).setLight(packedLight).setNormal(0.0f, -1.0f, 0.0f);
                builder.addVertex(matrix, corner, height, corner).setColor(color).setUv(minU, minV).setLight(packedLight).setNormal(0.0f, -1.0f, 0.0f);
            } else {
                builder.addVertex(matrix, corner, height, corner).setColor(color).setUv(minU, minV).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
                builder.addVertex(matrix, corner, height, 1.0f - corner).setColor(color).setUv(minU, maxV).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
                builder.addVertex(matrix, 1.0f - corner, height, 1.0f - corner).setColor(color).setUv(maxU, maxV).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
                builder.addVertex(matrix, 1.0f - corner, height, corner).setColor(color).setUv(maxU, minV).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
            }
        }
    }
}

