/*
 * Decompiled with CFR 0.152.
 */
package cubicoder.well.block.entity;

import cubicoder.well.block.ModBlocks;
import cubicoder.well.block.WellBlock;
import cubicoder.well.config.WellConfig;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class WellBlockEntity
extends BlockEntity {
    public int fillTick = 0;
    public int nearbyWells = 1;
    public int delayUntilNextBucket = 0;
    private WellFluidTank tank = new WellFluidTank(this, (Integer)WellConfig.tankCapacity.get());

    public WellBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.WELL_BE.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, WellBlockEntity well) {
        if (well.delayUntilNextBucket > 0) {
            --well.delayUntilNextBucket;
        }
        if (well.fillTick > 0) {
            --well.fillTick;
            well.setChanged();
        }
        if (well.fillTick <= 0 && WellConfig.canGenerateFluid(well.nearbyWells)) {
            FluidStack fluidToFill = well.getFluidToFill();
            int result = 0;
            if (fluidToFill != null) {
                result = well.tank.fill(fluidToFill, IFluidHandler.FluidAction.EXECUTE);
            }
            if (result > 0) {
                well.initFillTick();
                well.setChanged();
            }
        }
    }

    public void onLoad() {
        if (this.tank.updateLight(this.tank.getFluid())) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    protected FluidStack getFluidToFill() {
        return WellConfig.getFillFluid((Biome)this.level.getBiome(this.getBlockPos()).value(), this.level, this.getBlockPos(), this.isUpsideDown(), this.nearbyWells);
    }

    public void initFillTick() {
        this.fillTick = WellConfig.getFillDelay((Biome)this.level.getBiome(this.getBlockPos()).value(), this.level, this.level.random, this.isUpsideDown());
    }

    public void countNearbyWells(Consumer<WellBlockEntity> updateScript) {
        this.level.getChunkAt(this.getBlockPos()).getBlockEntitiesPos().forEach(otherPos -> {
            WellBlockEntity well;
            BlockEntity be;
            if (!otherPos.equals((Object)this.getBlockPos()) && (be = this.level.getBlockEntity(otherPos)) instanceof WellBlockEntity && (well = (WellBlockEntity)be).isUpsideDown() == this.isUpsideDown()) {
                updateScript.accept(well);
            }
        });
    }

    public boolean isUpsideDown() {
        return (Boolean)this.getBlockState().getValue((Property)WellBlock.UPSIDE_DOWN);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.fillTick = tag.getInt("FillTick");
        this.nearbyWells = Math.max(1, tag.getInt("NearbyWells"));
        this.tank.readFromNBT(registries, tag);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("FillTick", this.fillTick);
        tag.putInt("NearbyWells", this.nearbyWells);
        this.tank.writeToNBT(registries, tag);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        boolean wasFull;
        FluidStack oldFluid = this.tank.getFluid();
        this.handleUpdateTag(pkt.getTag(), lookupProvider);
        FluidStack newFluid = this.tank.getFluid();
        boolean wasEmpty = newFluid != null && oldFluid == null;
        boolean bl = wasFull = newFluid == null && oldFluid != null;
        if (wasEmpty || wasFull || newFluid != null && newFluid.getAmount() != oldFluid.getAmount()) {
            if (newFluid != null) {
                this.tank.updateLight(newFluid);
            } else {
                this.tank.updateLight(oldFluid);
            }
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public static class WellFluidTank
    extends FluidTank {
        private WellBlockEntity well;

        public WellFluidTank(WellBlockEntity well, int capacity) {
            super(capacity);
            this.well = well;
            this.setValidator(fluid -> {
                boolean isLighterThanAir = fluid.getFluid().getFluidType().isLighterThanAir();
                if (this.well.isUpsideDown()) {
                    return isLighterThanAir;
                }
                if (isLighterThanAir) {
                    return false;
                }
                return !this.well.getLevel().dimensionType().ultraWarm() || !fluid.getFluid().getFluidType().isVaporizedOnPlacement(this.well.getLevel(), this.well.getBlockPos(), fluid);
            });
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            int fill;
            int n = fill = this.well.getFluidToFill().getFluid() == resource.getFluid() ? super.fill(resource, action) : 0;
            if (action.execute() && fill > 0) {
                BlockState state = this.well.getBlockState();
                this.well.getLevel().sendBlockUpdated(this.well.getBlockPos(), state, state, 3);
                this.updateLight(resource);
            }
            return fill;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            FluidStack resource = super.drain(maxDrain, action);
            if (resource != null && action.execute()) {
                BlockState state = this.well.getBlockState();
                this.well.getLevel().sendBlockUpdated(this.well.getBlockPos(), state, state, 3);
                this.updateLight(resource);
            }
            return resource;
        }

        protected boolean updateLight(FluidStack resource) {
            if (resource != null && resource.getFluid().getFluidType().getLightLevel(resource.getFluid().defaultFluidState(), (BlockAndTintGetter)this.well.getLevel(), this.well.getBlockPos()) > 0) {
                this.well.getLevel().getLightEngine().checkBlock(this.well.getBlockPos());
                return true;
            }
            return false;
        }
    }
}

