/*
 * Decompiled with CFR 0.152.
 */
package cubicoder.well.block;

import cubicoder.well.block.ModBlocks;
import cubicoder.well.block.entity.WellBlockEntity;
import cubicoder.well.config.WellConfig;
import cubicoder.well.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class WellBlock
extends Block
implements EntityBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final BooleanProperty UPSIDE_DOWN = BooleanProperty.create((String)"upside_down");
    public static final VoxelShape SHAPE_BASE = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Block.box((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    public static final VoxelShape SHAPE_INNER_SUPPORT = Shapes.or((VoxelShape)Block.box((double)7.5, (double)0.0, (double)1.0, (double)8.5, (double)15.0, (double)2.0), (VoxelShape[])new VoxelShape[]{Block.box((double)7.5, (double)0.0, (double)14.0, (double)8.5, (double)15.0, (double)15.0), Block.box((double)7.5, (double)7.0, (double)2.0, (double)8.5, (double)8.0, (double)14.0), Block.box((double)5.0, (double)4.5, (double)4.5, (double)11.0, (double)10.5, (double)11.5)});
    public static final VoxelShape SHAPE_ROOF = Shapes.or((VoxelShape)Block.box((double)5.5, (double)12.5, (double)0.0, (double)10.5, (double)15.707, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.75, (double)10.5, (double)0.0, (double)5.5, (double)13.75, (double)16.0), Block.box((double)10.5, (double)10.5, (double)0.0, (double)13.25, (double)13.75, (double)16.0), Block.box((double)0.0, (double)8.0, (double)0.0, (double)2.75, (double)11.25, (double)16.0), Block.box((double)13.25, (double)8.0, (double)0.0, (double)16.0, (double)11.25, (double)16.0), SHAPE_INNER_SUPPORT});

    public WellBlock(DyeColor mapColor) {
        super(BlockBehaviour.Properties.of().mapColor(mapColor).instrument(NoteBlockInstrument.BASEDRUM).strength(1.5f, 6.0f).requiresCorrectToolForDrops());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(AXIS, (Comparable)Direction.Axis.X)).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return state.getValue(HALF) == DoubleBlockHalf.LOWER ? new WellBlockEntity(pos, state) : null;
    }

    private <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> serverType, BlockEntityType<E> clientType, BlockEntityTicker<? super E> ticker) {
        return serverType == clientType ? ticker : null;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : this.createTickerHelper(type, ModBlocks.WELL_BE.get(), WellBlockEntity::serverTick);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS, HALF, UPSIDE_DOWN});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction.Axis axis;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction.Axis axis2 = axis = context.getPlayer().isCrouching() ? context.getHorizontalDirection().getClockWise().getAxis() : context.getHorizontalDirection().getAxis();
        if (pos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(pos.above()).canBeReplaced(context)) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)axis)).setValue((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(false));
        }
        if (pos.getY() > level.getMinBuildHeight() + 1 && level.getBlockState(pos.below()).canBeReplaced(context)) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)axis)).setValue((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(true));
        }
        return null;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        Direction flippedDir2;
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        Direction flippedDir1 = (Boolean)state.getValue((Property)UPSIDE_DOWN) != false ? Direction.DOWN : Direction.UP;
        Direction direction2 = flippedDir2 = (Boolean)state.getValue((Property)UPSIDE_DOWN) != false ? Direction.UP : Direction.DOWN;
        if ((direction.getAxis() != Direction.Axis.Y || half == DoubleBlockHalf.LOWER != (direction == flippedDir1) || neighborState.is((Block)this) && neighborState.getValue(HALF) != half) && (half != DoubleBlockHalf.LOWER || direction != flippedDir2 || state.canSurvive((LevelReader)level, currentPos))) {
            return state;
        }
        return Blocks.AIR.defaultBlockState();
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        level.setBlockAndUpdate(pos.above((Boolean)state.getValue((Property)UPSIDE_DOWN) != false ? -1 : 1), (BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER));
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof WellBlockEntity) {
            WellBlockEntity well = (WellBlockEntity)be;
            if (!level.isClientSide) {
                well.initFillTick();
                well.countNearbyWells(w -> {
                    ++w.nearbyWells;
                    ++well.nearbyWells;
                });
            }
            if (((Boolean)WellConfig.onlyOnePerChunk.get()).booleanValue() && placer instanceof ServerPlayer && well.nearbyWells > 1) {
                String message = (Boolean)state.getValue((Property)UPSIDE_DOWN) != false ? "warn.well.onePerChunkFlipped" : "warn.well.onePerChunk";
                ((ServerPlayer)placer).displayClientMessage((Component)Component.translatable((String)message), true);
            }
        }
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return super.canSurvive(state, level, pos);
        }
        BlockState base = level.getBlockState(pos.below((Boolean)state.getValue((Property)UPSIDE_DOWN) != false ? -1 : 1));
        if (state.getBlock() != this) {
            return super.canSurvive(state, level, pos);
        }
        return base.is((Block)this) && base.getValue(HALF) == DoubleBlockHalf.LOWER;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos otherPos;
        BlockState otherState;
        if (!level.isClientSide && state.getValue(HALF) == DoubleBlockHalf.UPPER && (otherState = level.getBlockState(otherPos = pos.below((Boolean)state.getValue((Property)UPSIDE_DOWN) != false ? -1 : 1))).is((Block)this) && otherState.getValue(HALF) == DoubleBlockHalf.LOWER) {
            if (player.isCreative()) {
                level.destroyBlock(otherPos, false, (Entity)player);
            } else {
                level.destroyBlock(otherPos, this.canHarvestBlock(state, (BlockGetter)level, pos, player), (Entity)player);
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity be = level.getBlockEntity(pos);
            if (be instanceof WellBlockEntity) {
                WellBlockEntity well = (WellBlockEntity)be;
                well.countNearbyWells(w -> --w.nearbyWells);
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity be;
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (player.getItemInHand(hand).getCapability(Capabilities.FluidHandler.ITEM) == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!level.isClientSide && (be = level.getBlockEntity(pos)) instanceof WellBlockEntity) {
            WellBlockEntity well = (WellBlockEntity)be;
            boolean delayFlag = true;
            boolean fillingItem = FluidUtil.tryFillContainer((ItemStack)player.getItemInHand((InteractionHand)hand), (IFluidHandler)well.getTank(), (int)Integer.MAX_VALUE, (Player)player, (boolean)false).success;
            if (fillingItem && well.delayUntilNextBucket > 0) {
                delayFlag = false;
            }
            if (delayFlag && FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)level, (BlockPos)pos, (Direction)hitResult.getDirection())) {
                if (((Boolean)WellConfig.playSound.get()).booleanValue() && fillingItem) {
                    level.playSound(null, pos.above(), ModSounds.CRANK.get(), SoundSource.BLOCKS, 0.25f, 1.0f);
                    well.delayUntilNextBucket = 32;
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        Fluid fluid;
        int baseFluidLight;
        FluidStack fluidStack;
        BlockEntity be;
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER && (be = level.getBlockEntity(pos)) instanceof WellBlockEntity && (fluidStack = ((WellBlockEntity)be).getTank().getFluid()) != null && !fluidStack.isEmpty() && (baseFluidLight = (fluid = fluidStack.getFluid()).getFluidType().getLightLevel(fluid.defaultFluidState(), (BlockAndTintGetter)be.getLevel(), pos)) > 0) {
            return Mth.clamp((int)((int)((double)(baseFluidLight * fluidStack.getAmount() / (Integer)WellConfig.tankCapacity.get()) + 0.5)), (int)1, (int)15);
        }
        return 0;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        WellBlockEntity well;
        FluidStack fluid;
        BlockEntity be;
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER && (be = level.getBlockEntity(pos)) instanceof WellBlockEntity && (fluid = (well = (WellBlockEntity)be).getTank().getFluid()) != null) {
            int amount = well.getTank().getFluidAmount();
            int capacity = well.getTank().getCapacity();
            boolean upsideDown = (Boolean)state.getValue((Property)UPSIDE_DOWN);
            FluidType fluidType = fluid.getFluid().getFluidType();
            if (!upsideDown) {
                if (entity.getY() < (double)pos.getY() + (double)WellBlock.getFluidRenderHeight(amount, capacity, upsideDown)) {
                    if (fluidType == NeoForgeMod.LAVA_TYPE) {
                        entity.lavaHurt();
                    }
                    if (fluidType.canExtinguish(entity) && !level.isClientSide && entity.isOnFire()) {
                        entity.clearFire();
                    }
                }
            } else if (entity.getY() > (double)pos.getY() + (double)WellBlock.getFluidRenderHeight(amount, capacity, upsideDown)) {
                // empty if block
            }
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        WellBlockEntity well;
        FluidStack fluid;
        BlockEntity be;
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER && (be = level.getBlockEntity(pos)) instanceof WellBlockEntity && (fluid = (well = (WellBlockEntity)be).getTank().getFluid()) != null) {
            int amount = well.getTank().getFluidAmount();
            int capacity = well.getTank().getCapacity();
            boolean upsideDown = (Boolean)state.getValue((Property)UPSIDE_DOWN);
            float height = WellBlock.getFluidRenderHeight(amount, capacity, upsideDown);
            FluidState fluidState = fluid.getFluid().defaultFluidState();
            fluidState.animateTick(level, pos, random);
            if (fluid.getFluid() == Fluids.LAVA) {
                double z;
                double y;
                double x;
                if (random.nextInt(100) == 0) {
                    x = (double)pos.getX() + random.nextDouble();
                    y = (double)pos.getY() + (double)height;
                    z = (double)pos.getZ() + random.nextDouble();
                    level.addParticle((ParticleOptions)ParticleTypes.LAVA, x, y, z, 0.0, 0.0, 0.0);
                    level.playLocalSound(x, y, z, SoundEvents.LAVA_POP, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
                }
                if (random.nextInt(200) == 0) {
                    x = (double)pos.getX() + 0.5;
                    y = (double)pos.getY() + (double)(height / 2.0f);
                    z = (double)pos.getZ() + 0.5;
                    level.playLocalSound(x, y, z, SoundEvents.LAVA_AMBIENT, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
                }
            }
        }
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        return state.getValue(HALF) == DoubleBlockHalf.UPPER ? this.soundType : Blocks.BRICKS.getSoundType(state, level, pos, entity);
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return (Boolean)state.getValue((Property)UPSIDE_DOWN) != false ? WellBlock.flipShapeUpsideDown(SHAPE_BASE) : SHAPE_BASE;
        }
        if (state.getValue(AXIS) == Direction.Axis.X) {
            return (Boolean)state.getValue((Property)UPSIDE_DOWN) != false ? WellBlock.flipShapeUpsideDown(SHAPE_ROOF) : SHAPE_ROOF;
        }
        return (Boolean)state.getValue((Property)UPSIDE_DOWN) != false ? WellBlock.flipShapeUpsideDown(WellBlock.flipShapeXZ(SHAPE_ROOF)) : WellBlock.flipShapeXZ(SHAPE_ROOF);
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return (Boolean)state.getValue((Property)UPSIDE_DOWN) != false ? WellBlock.flipShapeUpsideDown(SHAPE_BASE) : SHAPE_BASE;
        }
        if (state.getValue(AXIS) == Direction.Axis.X) {
            return (Boolean)state.getValue((Property)UPSIDE_DOWN) != false ? WellBlock.flipShapeUpsideDown(SHAPE_INNER_SUPPORT) : SHAPE_INNER_SUPPORT;
        }
        return (Boolean)state.getValue((Property)UPSIDE_DOWN) != false ? WellBlock.flipShapeUpsideDown(WellBlock.flipShapeXZ(SHAPE_INNER_SUPPORT)) : WellBlock.flipShapeXZ(SHAPE_INNER_SUPPORT);
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return Shapes.block();
        }
        if (state.getValue(AXIS) == Direction.Axis.X) {
            return (Boolean)state.getValue((Property)UPSIDE_DOWN) != false ? WellBlock.flipShapeUpsideDown(SHAPE_ROOF) : SHAPE_ROOF;
        }
        return (Boolean)state.getValue((Property)UPSIDE_DOWN) != false ? WellBlock.flipShapeUpsideDown(WellBlock.flipShapeXZ(SHAPE_ROOF)) : WellBlock.flipShapeXZ(SHAPE_ROOF);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return switch ((Direction.Axis)state.getValue(AXIS)) {
                    case Direction.Axis.Z -> (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
                    case Direction.Axis.X -> (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    default -> state;
                };
            }
        }
        return state;
    }

    public static VoxelShape flipShapeXZ(VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
            buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.create((double)minZ, (double)minY, (double)minX, (double)maxZ, (double)maxY, (double)maxX));
        });
        return buffer[1];
    }

    public static VoxelShape flipShapeUpsideDown(VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
            buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.create((double)minX, (double)(1.0 - maxY), (double)minZ, (double)maxX, (double)(1.0 - minY), (double)maxZ));
        });
        return buffer[1];
    }

    public static float getFluidRenderHeight(int amount, int capacity, boolean upsideDown) {
        float height = (float)amount * 14.0f / (float)(16 * capacity) + 0.125f;
        return upsideDown ? 1.0f - height : height;
    }
}

