/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.datagen.api.provider;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.betterx.wover.block.api.BlockRegistry;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.betterx.wover.block.impl.ModelProviderExclusions;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.datagen.api.WoverDataProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WoverModelProvider
implements WoverDataProvider<FabricModelProvider> {
    public final String title;
    protected final ModCore modCore;

    public WoverModelProvider(ModCore modCore) {
        this(modCore, modCore.namespace);
    }

    public WoverModelProvider(ModCore modCore, String title) {
        this.modCore = modCore;
        this.title = title;
    }

    protected void addFromRegistry(WoverBlockModelGenerators generator, BlockRegistry registry, boolean validate) {
        this.addFromRegistry(generator, registry, validate, ModelOverides.create());
    }

    protected void addFromRegistry(WoverBlockModelGenerators generator, BlockRegistry registry, boolean validateMissing, ModelOverides overrides) {
        registry.allBlocks().forEach(block -> {
            if (!overrides.provideBlockModel((Block)block) && block instanceof BlockModelProvider) {
                BlockModelProvider bmp = (BlockModelProvider)block;
                bmp.provideBlockModels(generator);
            } else if (validateMissing) {
                ModelProviderExclusions.excludeFromBlockModelValidation(block);
            }
            if (!validateMissing) {
                ModelProviderExclusions.excludeFromBlockModelValidation(block);
            }
        });
    }

    protected abstract void bootstrapBlockStateModels(WoverBlockModelGenerators var1);

    protected abstract void bootstrapItemModels(ItemModelGenerators var1);

    public FabricModelProvider getProvider(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
        return new FabricModelProvider(output){

            public String getName() {
                return super.getName() + " - " + WoverModelProvider.this.title;
            }

            public void generateBlockStateModels(BlockModelGenerators blockStateModelGenerator) {
                WoverModelProvider.this.bootstrapBlockStateModels(new WoverBlockModelGenerators(blockStateModelGenerator));
            }

            public void generateItemModels(ItemModelGenerators itemModelGenerator) {
                WoverModelProvider.this.bootstrapItemModels(itemModelGenerator);
            }
        };
    }

    public static class ModelOverides {
        private final Map<Block, BlockModelProvider> OVERRIDES = new HashMap<Block, BlockModelProvider>();
        private static final BlockModelProvider IGNORE = block -> {};

        public static ModelOverides create() {
            return new ModelOverides();
        }

        public ModelOverides override(@Nullable Block block, @NotNull BlockModelProvider provider) {
            if (block == Blocks.AIR || block == null) {
                return this;
            }
            BlockModelProvider old = this.OVERRIDES.put(block, provider);
            if (old != null) {
                throw new IllegalStateException("Block " + String.valueOf(block) + " already has an override.");
            }
            return this;
        }

        public ModelOverides overrideLike(@Nullable Block block, @NotNull Block copyFromBlock) {
            if (block == Blocks.AIR || block == null) {
                return this;
            }
            return this.override(block, this.OVERRIDES.get(copyFromBlock));
        }

        public ModelOverides ignore(@Nullable Block block) {
            if (block == Blocks.AIR || block == null) {
                return this;
            }
            return this.override(block, IGNORE);
        }

        public boolean contain(Block block) {
            return this.OVERRIDES.containsKey(block);
        }

        boolean provideBlockModel(Block block) {
            BlockModelProvider override = this.OVERRIDES.get(block);
            if (override != null) {
                override.provideModels(block);
                return true;
            }
            return false;
        }

        private ModelOverides() {
        }

        public static interface BlockModelProvider {
            public void provideModels(Block var1);
        }
    }
}

