/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.block.api;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootTable;
import org.betterx.wover.block.api.BlockTagProvider;
import org.betterx.wover.block.api.CustomBlockItemProvider;
import org.betterx.wover.block.impl.WoverBlockItemImpl;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.item.api.ItemRegistry;
import org.betterx.wover.loot.api.BlockLootProvider;
import org.betterx.wover.loot.api.LootLookupProvider;
import org.betterx.wover.loot.api.LootTableManager;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;
import org.jetbrains.annotations.NotNull;

public class BlockRegistry {
    private static final Map<ModCore, BlockRegistry> REGISTRIES = new HashMap<ModCore, BlockRegistry>();
    public final ModCore C;
    private final Map<ResourceLocation, Block> blocks = new HashMap<ResourceLocation, Block>();
    private Map<Block, TagKey<Block>[]> datagenTags;
    private final ItemRegistry itemRegistry;

    private BlockRegistry(ModCore modeCore) {
        this.C = modeCore;
        this.itemRegistry = ItemRegistry.forMod((ModCore)modeCore);
        if (ModCore.isDatagen()) {
            this.datagenTags = new HashMap<Block, TagKey<Block>[]>();
        }
    }

    public static Stream<BlockRegistry> streamAll() {
        return REGISTRIES.values().stream();
    }

    public static BlockRegistry forMod(ModCore modCore) {
        return REGISTRIES.computeIfAbsent(modCore, c -> new BlockRegistry(modCore));
    }

    public Stream<Block> allBlocks() {
        return this.blocks.values().stream();
    }

    public Stream<BlockItem> allBlockItems() {
        return this.blocks.values().stream().filter(block -> block.asItem() instanceof BlockItem).map(block -> (BlockItem)block.asItem());
    }

    @SafeVarargs
    public final <T extends Block> T register(String path, T block, TagKey<Block> ... tags) {
        return this.register(path, block, tags, (TagKey<Item>[])null);
    }

    public <T extends Block> T register(String path, T block, TagKey<Block>[] tags, TagKey<Item>[] itemTags) {
        if (block != null && block != Blocks.AIR) {
            BlockItem item;
            ResourceLocation id;
            ResourceLocation resourceLocation = id = tags == null ? this._registerBlockOnly(path, block, new TagKey[0]) : this._registerBlockOnly(path, block, tags);
            if (block instanceof CustomBlockItemProvider) {
                CustomBlockItemProvider provider = (CustomBlockItemProvider)block;
                item = provider.getCustomBlockItem(id, this.defaultBlockItemSettings());
            } else {
                item = WoverBlockItemImpl.create(block, this.defaultBlockItemSettings());
            }
            if (itemTags == null) {
                this.registerBlockItem(path, item, new TagKey[0]);
            } else {
                this.registerBlockItem(path, item, itemTags);
            }
            if (block.defaultBlockState().ignitedByLava() && ((FlammableBlockRegistry.Entry)FlammableBlockRegistry.getDefaultInstance().get(block)).getBurnChance() == 0) {
                FlammableBlockRegistry.getDefaultInstance().add(block, 5, 5);
            }
        }
        return block;
    }

    @SafeVarargs
    private ResourceLocation _registerBlockOnly(String path, Block block, TagKey<Block> ... tags) {
        ResourceLocation id = this.C.mk(path);
        Registry.register((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)id, (Object)block);
        this.blocks.put(id, block);
        if (this.datagenTags != null && tags != null && tags.length > 0) {
            this.datagenTags.put(block, tags);
        }
        return id;
    }

    @SafeVarargs
    public final <T extends Block> T registerBlockOnly(String path, T block, TagKey<Block> ... tags) {
        if (block != null && block != Blocks.AIR) {
            this._registerBlockOnly(path, block, tags);
        }
        return block;
    }

    @SafeVarargs
    private BlockItem registerBlockItem(String path, BlockItem item, TagKey<Item> ... tags) {
        return (BlockItem)this.itemRegistry.register(path, (Item)item, tags);
    }

    protected Item.Properties defaultBlockItemSettings() {
        return new Item.Properties();
    }

    public void bootstrapBlockTags(TagBootstrapContext<Block> ctx) {
        if (this.datagenTags != null) {
            this.datagenTags.forEach((arg_0, arg_1) -> ctx.add(arg_0, arg_1));
        }
        this.blocks.entrySet().stream().filter(b -> b.getValue() instanceof BlockTagProvider).forEach(b -> ((BlockTagProvider)b.getValue()).registerBlockTags((ResourceLocation)b.getKey(), ctx));
    }

    public void bootstrapBlockLoot(@NotNull HolderLookup.Provider lookup, @NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> biConsumer) {
        LootLookupProvider provider = new LootLookupProvider(lookup);
        this.blocks.entrySet().stream().filter(b -> b.getValue() instanceof BlockLootProvider).forEach(b -> {
            ResourceKey<LootTable> key = LootTableManager.getBlockLootTableKey(this.C, (ResourceLocation)b.getKey());
            LootTable.Builder builder = ((BlockLootProvider)b.getValue()).registerBlockLoot((ResourceLocation)b.getKey(), provider, key);
            if (builder != null) {
                biConsumer.accept(key, builder);
            }
        });
    }
}

