/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.debug;

import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.node.GraphNetworkComponent;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DebugStickItem
extends Item {
    public DebugStickItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Level level = context.getLevel();
        BlockEntity blockEntity = level.getBlockEntity(context.getClickedPos());
        if (blockEntity != null) {
            DebugStickItem.dump(level, blockEntity, player);
        }
        return InteractionResult.CONSUME;
    }

    private static void dump(Level level, BlockEntity blockEntity, Player player) {
        if (level.isClientSide()) {
            return;
        }
        if (!(blockEntity instanceof AbstractBaseNetworkNodeContainerBlockEntity)) {
            return;
        }
        AbstractBaseNetworkNodeContainerBlockEntity provider = (AbstractBaseNetworkNodeContainerBlockEntity)blockEntity;
        provider.getContainerProvider().getContainers().forEach(container -> DebugStickItem.dump(player, container));
        player.sendSystemMessage((Component)Component.literal((String)"---"));
    }

    private static void dump(Player player, InWorldNetworkNodeContainer container) {
        Network network = container.getNode().getNetwork();
        player.sendSystemMessage((Component)Component.literal((String)(container.getNode().getClass().getSimpleName() + " --> ")).append((Component)(network == null ? Component.literal((String)"<NULL>").withStyle(ChatFormatting.RED) : Component.literal((String)("" + network.hashCode())).withStyle(ChatFormatting.AQUA))));
        if (network != null) {
            DebugStickItem.dump(player, network);
        }
    }

    private static void dump(Player player, Network network) {
        Map nodesByType = network.getComponent(GraphNetworkComponent.class).getContainers().stream().map(c -> c.getNode().getClass().getSimpleName()).reduce(new LinkedHashMap(), (map, name) -> {
            map.put(name, map.getOrDefault(name, 0) + 1);
            return map;
        }, (m1, m2) -> {
            m1.putAll(m2);
            return m1;
        });
        nodesByType.forEach((type, amount) -> player.sendSystemMessage((Component)Component.literal((String)(amount + "x ")).withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)type).withStyle(ChatFormatting.GOLD))));
    }
}

