/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.datagen;

import com.refinedmods.refinedstorage.common.content.BlockColorMap;
import com.refinedmods.refinedstorage.common.content.Blocks;
import com.refinedmods.refinedstorage.common.content.ContentIds;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.refinedmods.refinedstorage.neoforge.datagen.ColoredCustomLoaderBuilder;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BlockModelProviderImpl
extends BlockModelProvider {
    private static final String PARTICLE_TEXTURE = "particle";
    private static final String CUTOUT_TEXTURE = "cutout";
    private static final String BLOCK_PREFIX = "block";
    private static final ResourceLocation EMISSIVE_CUTOUT = IdentifierUtil.createIdentifier("block/emissive_cutout");
    private static final ResourceLocation EMISSIVE_ALL_CUTOUT = IdentifierUtil.createIdentifier("block/emissive_all_cutout");
    private static final ResourceLocation EMISSIVE_SIDES_CUTOUT = IdentifierUtil.createIdentifier("block/emissive_sides_cutout");
    private static final ResourceLocation EMISSIVE_NORTH_CUTOUT = IdentifierUtil.createIdentifier("block/emissive_north_cutout");
    private static final ResourceLocation CUTOUT = IdentifierUtil.createIdentifier("block/cutout");
    private static final ResourceLocation SIDES_CUTOUT = IdentifierUtil.createIdentifier("block/sides_cutout");
    private static final ResourceLocation ALL_CUTOUT = IdentifierUtil.createIdentifier("block/all_cutout");
    private static final ResourceLocation NORTH_CUTOUT = IdentifierUtil.createIdentifier("block/north_cutout");
    private static final ResourceLocation BOTTOM_TEXTURE = IdentifierUtil.createIdentifier("block/bottom");
    private static final String CUTOUT_NORTH = "cutout_north";
    private static final String CUTOUT_EAST = "cutout_east";
    private static final String CUTOUT_SOUTH = "cutout_south";
    private static final String CUTOUT_WEST = "cutout_west";
    private static final String CUTOUT_UP = "cutout_up";
    private static final String CUTOUT_DOWN = "cutout_down";
    private static final String NORTH = "north";
    private static final String EAST = "east";
    private static final String SOUTH = "south";
    private static final String WEST = "west";
    private static final String UP = "up";
    private static final String DOWN = "down";

    public BlockModelProviderImpl(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "refinedstorage", existingFileHelper);
    }

    protected void registerModels() {
        this.registerCables();
        this.registerControllers();
        this.registerRightLeftBackFrontTopModel(Blocks.INSTANCE.getGrid(), "grid");
        this.registerRightLeftBackFrontTopModel(Blocks.INSTANCE.getCraftingGrid(), "crafting_grid");
        this.registerRightLeftBackFrontTopModel(Blocks.INSTANCE.getPatternGrid(), "pattern_grid");
        this.registerRightLeftBackFrontTopModel(Blocks.INSTANCE.getAutocrafterManager(), "autocrafter_manager");
        this.registerRightLeftBackFrontTopModel(Blocks.INSTANCE.getAutocraftingMonitor(), "autocrafting_monitor");
        this.registerDetectors();
        this.registerWirelessTransmitters();
        this.registerNetworkReceivers();
        this.registerNetworkTransmitters();
        this.registerSecurityManagers();
        this.registerRelays();
        this.registerDiskInterfaces();
        this.registerAutocrafters();
    }

    private void registerCables() {
        ResourceLocation coreBase = IdentifierUtil.createIdentifier("block/cable/core/base");
        ResourceLocation extensionBase = IdentifierUtil.createIdentifier("block/cable/extension/base");
        Blocks.INSTANCE.getCable().forEach((color, id, cable) -> {
            ResourceLocation texture = IdentifierUtil.createIdentifier("block/cable/" + color.getName());
            ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/cable/core/" + color.getName(), coreBase)).texture("cable", texture)).texture(PARTICLE_TEXTURE, texture);
            ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/cable/extension/" + color.getName(), extensionBase)).texture("cable", texture)).texture(PARTICLE_TEXTURE, texture);
            ((ColoredCustomLoaderBuilder)((BlockModelBuilder)this.getBuilder("block/cable/" + color.getName())).customLoader((blockModelBuilder, existingFileHelper) -> new ColoredCustomLoaderBuilder<BlockModelBuilder>(this, ContentIds.CABLE, blockModelBuilder, existingFileHelper, color){})).end();
        });
    }

    private void registerControllers() {
        ResourceLocation off = IdentifierUtil.createIdentifier("block/controller/off");
        ResourceLocation on = IdentifierUtil.createIdentifier("block/controller/on");
        Blocks.INSTANCE.getController().forEach((color, id, controller) -> {
            ResourceLocation cutout = IdentifierUtil.createIdentifier("block/controller/cutouts/" + color.getName());
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/controller/" + color.getName(), EMISSIVE_ALL_CUTOUT)).texture(PARTICLE_TEXTURE, off)).texture("all", on)).texture(CUTOUT_TEXTURE, cutout);
        });
    }

    private void registerRightLeftBackFrontTopModel(BlockColorMap<?, ?> blockMap, String name) {
        this.registerRightLeftBackFrontTopModel(blockMap, name, "");
    }

    private void registerRightLeftBackFrontTopModel(BlockColorMap<?, ?> blockMap, String name, String modelPrefix) {
        blockMap.forEach((color, id, block) -> {
            ResourceLocation cutout = IdentifierUtil.createIdentifier("block/" + name + "/cutouts/" + color.getName());
            this.registerRightLeftBackFrontTopModel(name, modelPrefix + color.getName(), cutout, EMISSIVE_NORTH_CUTOUT);
        });
        ResourceLocation inactiveCutout = IdentifierUtil.createIdentifier("block/" + name + "/cutouts/inactive");
        this.registerRightLeftBackFrontTopModel(name, "inactive", inactiveCutout, NORTH_CUTOUT);
    }

    private void registerRightLeftBackFrontTopModel(String name, String variantName, ResourceLocation cutout, ResourceLocation baseModel) {
        ResourceLocation right = IdentifierUtil.createIdentifier("block/" + name + "/right");
        ResourceLocation left = IdentifierUtil.createIdentifier("block/" + name + "/left");
        ResourceLocation back = IdentifierUtil.createIdentifier("block/" + name + "/back");
        ResourceLocation front = IdentifierUtil.createIdentifier("block/" + name + "/front");
        ResourceLocation top = IdentifierUtil.createIdentifier("block/" + name + "/top");
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/" + name + "/" + variantName, baseModel)).texture(PARTICLE_TEXTURE, right)).texture(NORTH, front)).texture(EAST, right)).texture(SOUTH, back)).texture(WEST, left)).texture(UP, top)).texture(DOWN, BOTTOM_TEXTURE)).texture(CUTOUT_TEXTURE, cutout);
    }

    private void registerDetectors() {
        ResourceLocation parent = IdentifierUtil.createIdentifier("block/detector/powered");
        ResourceLocation side = IdentifierUtil.createIdentifier("block/detector/side");
        ResourceLocation bottom = IdentifierUtil.createIdentifier("block/detector/bottom");
        ResourceLocation top = IdentifierUtil.createIdentifier("block/detector/top");
        ResourceLocation particle = IdentifierUtil.createIdentifier("block/detector/side");
        Blocks.INSTANCE.getDetector().forEach((color, id, block) -> {
            ResourceLocation torch = IdentifierUtil.createIdentifier("block/detector/cutouts/" + color.getName());
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/detector/" + color.getName(), parent)).texture("side", side)).texture("bottom", bottom)).texture("top", top)).texture(PARTICLE_TEXTURE, particle)).texture("torch", torch);
        });
    }

    private void registerWirelessTransmitters() {
        ResourceLocation parent = IdentifierUtil.createIdentifier("block/wireless_transmitter/active");
        Blocks.INSTANCE.getWirelessTransmitter().forEach((color, id, block) -> ((BlockModelBuilder)this.withExistingParent("block/wireless_transmitter/" + color.getName(), parent)).texture(CUTOUT_TEXTURE, IdentifierUtil.createIdentifier("block/wireless_transmitter/cutouts/" + color.getName())));
    }

    private void registerNetworkReceivers() {
        ResourceLocation baseTexture = IdentifierUtil.createIdentifier("block/network_receiver/base");
        Blocks.INSTANCE.getNetworkReceiver().forEach((color, id, receiver) -> {
            ResourceLocation cutout = IdentifierUtil.createIdentifier("block/network_receiver/cutouts/" + color.getName());
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/network_receiver/" + color.getName(), EMISSIVE_ALL_CUTOUT)).texture(PARTICLE_TEXTURE, baseTexture)).texture("all", baseTexture)).texture(CUTOUT_TEXTURE, cutout);
        });
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/network_receiver/inactive", ALL_CUTOUT)).texture(PARTICLE_TEXTURE, baseTexture)).texture("all", baseTexture)).texture(CUTOUT_TEXTURE, IdentifierUtil.createIdentifier("block/network_receiver/cutouts/inactive"));
    }

    private void registerNetworkTransmitters() {
        ResourceLocation baseTexture = IdentifierUtil.createIdentifier("block/network_transmitter/base");
        Blocks.INSTANCE.getNetworkTransmitter().forEach((color, id, receiver) -> {
            ResourceLocation cutout = IdentifierUtil.createIdentifier("block/network_transmitter/cutouts/" + color.getName());
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/network_transmitter/" + color.getName(), EMISSIVE_ALL_CUTOUT)).texture(PARTICLE_TEXTURE, baseTexture)).texture("all", baseTexture)).texture(CUTOUT_TEXTURE, cutout);
        });
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/network_transmitter/inactive", ALL_CUTOUT)).texture(PARTICLE_TEXTURE, baseTexture)).texture("all", baseTexture)).texture(CUTOUT_TEXTURE, IdentifierUtil.createIdentifier("block/network_transmitter/cutouts/inactive"));
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/network_transmitter/error", EMISSIVE_ALL_CUTOUT)).texture(PARTICLE_TEXTURE, baseTexture)).texture("all", baseTexture)).texture(CUTOUT_TEXTURE, IdentifierUtil.createIdentifier("block/network_transmitter/cutouts/error"));
    }

    private void registerSecurityManagers() {
        ResourceLocation back = IdentifierUtil.createIdentifier("block/security_manager/back");
        ResourceLocation front = IdentifierUtil.createIdentifier("block/security_manager/front");
        ResourceLocation left = IdentifierUtil.createIdentifier("block/security_manager/left");
        ResourceLocation right = IdentifierUtil.createIdentifier("block/security_manager/right");
        ResourceLocation top = IdentifierUtil.createIdentifier("block/security_manager/top");
        Blocks.INSTANCE.getNetworkTransmitter().forEach((color, id, receiver) -> {
            ResourceLocation cutoutBack = IdentifierUtil.createIdentifier("block/security_manager/cutouts/back/" + color.getName());
            ResourceLocation cutoutFront = IdentifierUtil.createIdentifier("block/security_manager/cutouts/front/" + color.getName());
            ResourceLocation cutoutLeft = IdentifierUtil.createIdentifier("block/security_manager/cutouts/left/" + color.getName());
            ResourceLocation cutoutRight = IdentifierUtil.createIdentifier("block/security_manager/cutouts/right/" + color.getName());
            ResourceLocation cutoutTop = IdentifierUtil.createIdentifier("block/security_manager/cutouts/top/" + color.getName());
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/security_manager/" + color.getName(), EMISSIVE_SIDES_CUTOUT)).texture(PARTICLE_TEXTURE, back)).texture(NORTH, front)).texture(EAST, right)).texture(SOUTH, back)).texture(WEST, left)).texture(UP, top)).texture(DOWN, BOTTOM_TEXTURE)).texture(CUTOUT_NORTH, cutoutFront)).texture(CUTOUT_EAST, cutoutRight)).texture(CUTOUT_SOUTH, cutoutBack)).texture(CUTOUT_WEST, cutoutLeft)).texture(CUTOUT_UP, cutoutTop);
        });
        ResourceLocation cutoutBack = IdentifierUtil.createIdentifier("block/security_manager/cutouts/back/inactive");
        ResourceLocation cutoutFront = IdentifierUtil.createIdentifier("block/security_manager/cutouts/front/inactive");
        ResourceLocation cutoutLeft = IdentifierUtil.createIdentifier("block/security_manager/cutouts/left/inactive");
        ResourceLocation cutoutRight = IdentifierUtil.createIdentifier("block/security_manager/cutouts/right/inactive");
        ResourceLocation cutoutTop = IdentifierUtil.createIdentifier("block/security_manager/cutouts/top/inactive");
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/security_manager/inactive", SIDES_CUTOUT)).texture(PARTICLE_TEXTURE, back)).texture(NORTH, front)).texture(EAST, right)).texture(SOUTH, back)).texture(WEST, left)).texture(UP, top)).texture(DOWN, BOTTOM_TEXTURE)).texture(CUTOUT_NORTH, cutoutFront)).texture(CUTOUT_EAST, cutoutRight)).texture(CUTOUT_SOUTH, cutoutBack)).texture(CUTOUT_WEST, cutoutLeft)).texture(CUTOUT_UP, cutoutTop);
    }

    private void registerRelays() {
        ResourceLocation in = IdentifierUtil.createIdentifier("block/relay/in");
        ResourceLocation out = IdentifierUtil.createIdentifier("block/relay/out");
        Blocks.INSTANCE.getNetworkTransmitter().forEach((color, id, receiver) -> {
            ResourceLocation cutoutIn = IdentifierUtil.createIdentifier("block/relay/cutouts/in/" + color.getName());
            ResourceLocation cutoutOut = IdentifierUtil.createIdentifier("block/relay/cutouts/out/" + color.getName());
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/relay/" + color.getName(), EMISSIVE_CUTOUT)).texture(PARTICLE_TEXTURE, in)).texture(NORTH, out)).texture(EAST, in)).texture(SOUTH, in)).texture(WEST, in)).texture(UP, in)).texture(DOWN, in)).texture(CUTOUT_NORTH, cutoutOut)).texture(CUTOUT_EAST, cutoutIn)).texture(CUTOUT_SOUTH, cutoutIn)).texture(CUTOUT_WEST, cutoutIn)).texture(CUTOUT_UP, cutoutIn)).texture(CUTOUT_DOWN, cutoutIn);
        });
        ResourceLocation cutoutIn = IdentifierUtil.createIdentifier("block/relay/cutouts/in/inactive");
        ResourceLocation cutoutOut = IdentifierUtil.createIdentifier("block/relay/cutouts/out/inactive");
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/relay/inactive", CUTOUT)).texture(PARTICLE_TEXTURE, in)).texture(NORTH, out)).texture(EAST, in)).texture(SOUTH, in)).texture(WEST, in)).texture(UP, in)).texture(DOWN, in)).texture(CUTOUT_NORTH, cutoutOut)).texture(CUTOUT_EAST, cutoutIn)).texture(CUTOUT_SOUTH, cutoutIn)).texture(CUTOUT_WEST, cutoutIn)).texture(CUTOUT_UP, cutoutIn)).texture(CUTOUT_DOWN, cutoutIn);
    }

    private void registerDiskInterfaces() {
        this.registerRightLeftBackFrontTopModel(Blocks.INSTANCE.getDiskInterface(), "disk_interface", "base_");
        Blocks.INSTANCE.getDiskInterface().forEach((color, id, block) -> ((ColoredCustomLoaderBuilder)((BlockModelBuilder)this.getBuilder("block/disk_interface/" + color.getName())).customLoader((blockModelBuilder, existingFileHelper) -> new ColoredCustomLoaderBuilder<BlockModelBuilder>(this, ContentIds.DISK_INTERFACE, blockModelBuilder, existingFileHelper, color){})).end());
    }

    private void registerAutocrafters() {
        ResourceLocation side = IdentifierUtil.createIdentifier("block/autocrafter/side");
        ResourceLocation top = IdentifierUtil.createIdentifier("block/autocrafter/top");
        Blocks.INSTANCE.getAutocrafter().forEach((color, id, autocrafter) -> {
            ResourceLocation cutoutSide = IdentifierUtil.createIdentifier("block/autocrafter/cutouts/side/" + color.getName());
            ResourceLocation cutoutTop = IdentifierUtil.createIdentifier("block/autocrafter/cutouts/top/" + color.getName());
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/autocrafter/" + color.getName(), EMISSIVE_SIDES_CUTOUT)).texture(PARTICLE_TEXTURE, side)).texture(NORTH, side)).texture(EAST, side)).texture(SOUTH, side)).texture(WEST, side)).texture(UP, top)).texture(DOWN, BOTTOM_TEXTURE)).texture(CUTOUT_NORTH, cutoutSide)).texture(CUTOUT_EAST, cutoutSide)).texture(CUTOUT_SOUTH, cutoutSide)).texture(CUTOUT_WEST, cutoutSide)).texture(CUTOUT_UP, cutoutTop);
        });
        ResourceLocation cutoutSide = IdentifierUtil.createIdentifier("block/autocrafter/cutouts/side/inactive");
        ResourceLocation cutoutTop = IdentifierUtil.createIdentifier("block/autocrafter/cutouts/top/inactive");
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/autocrafter/inactive", SIDES_CUTOUT)).texture(PARTICLE_TEXTURE, side)).texture(NORTH, side)).texture(EAST, side)).texture(SOUTH, side)).texture(WEST, side)).texture(UP, top)).texture(DOWN, BOTTOM_TEXTURE)).texture(CUTOUT_NORTH, cutoutSide)).texture(CUTOUT_EAST, cutoutSide)).texture(CUTOUT_SOUTH, cutoutSide)).texture(CUTOUT_WEST, cutoutSide)).texture(CUTOUT_UP, cutoutTop);
    }
}

