/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.util;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public final class IdentifierUtil {
    public static final String MOD_ID = "refinedstorage";
    public static final MutableComponent YES = Component.translatable((String)"gui.yes");
    public static final MutableComponent NO = Component.translatable((String)"gui.no");
    private static final DecimalFormat FORMATTER_WITH_UNITS = new DecimalFormat("####0.#", DecimalFormatSymbols.getInstance(Locale.US));
    private static final DecimalFormat FORMATTER = new DecimalFormat("#,###", DecimalFormatSymbols.getInstance(Locale.US));

    private IdentifierUtil() {
    }

    public static ResourceLocation createIdentifier(String value) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)value);
    }

    public static String createTranslationKey(String category, String value) {
        return String.format("%s.%s.%s", category, MOD_ID, value);
    }

    public static MutableComponent createTranslation(String category, String value) {
        return Component.translatable((String)IdentifierUtil.createTranslationKey(category, value));
    }

    public static MutableComponent createTranslation(String category, String value, Object ... args) {
        return Component.translatable((String)IdentifierUtil.createTranslationKey(category, value), (Object[])args);
    }

    public static MutableComponent createStoredWithCapacityTranslation(long stored, long capacity, double pct) {
        return IdentifierUtil.createTranslation("misc", "stored_with_capacity", Component.literal((String)(stored == Long.MAX_VALUE ? "\u221e" : IdentifierUtil.format(stored))).withStyle(ChatFormatting.WHITE), Component.literal((String)(capacity == Long.MAX_VALUE ? "\u221e" : IdentifierUtil.format(capacity))).withStyle(ChatFormatting.WHITE), Component.literal((String)String.valueOf((int)(pct * 100.0)))).withStyle(ChatFormatting.GRAY);
    }

    public static MutableComponent createTranslationAsHeading(String category, String value) {
        return Component.literal((String)"<").append((Component)IdentifierUtil.createTranslation(category, value)).append(">").withStyle(ChatFormatting.DARK_GRAY);
    }

    public static String getTagTranslationKey(TagKey<?> key) {
        ResourceLocation registry = key.registry().location();
        String fixedPath = registry.getPath().replace('/', '.');
        if (registry.getNamespace().equals("minecraft")) {
            return IdentifierUtil.getTagTranslationKey("tag.%s.".formatted(fixedPath), key.location());
        }
        return IdentifierUtil.getTagTranslationKey("tag.%s.%s.".formatted(registry.getNamespace(), fixedPath), key.location());
    }

    private static String getTagTranslationKey(String prefix, ResourceLocation id) {
        String fixedPath = id.getPath().replace('/', '.');
        return prefix + id.getNamespace() + "." + fixedPath;
    }

    public static String formatWithUnits(double qty) {
        if (qty < 0.001) {
            return "0";
        }
        return switch ((int)Math.floor(Math.log10(qty) / 3.0)) {
            case -1 -> FORMATTER_WITH_UNITS.format(qty * 1000.0) + "m";
            case 0 -> FORMATTER_WITH_UNITS.format(qty >= 100.0 ? Math.floor(qty) : qty);
            case 1 -> FORMATTER_WITH_UNITS.format(qty >= 100000.0 ? Math.floor(qty / 1000.0) : qty / 1000.0) + "k";
            case 2 -> FORMATTER_WITH_UNITS.format(qty >= 1.0E8 ? Math.floor(qty / 1000000.0) : qty / 1000000.0) + "M";
            case 3 -> FORMATTER_WITH_UNITS.format(qty >= 1.0E11 ? Math.floor(qty / 1.0E9) : qty / 1.0E9) + "G";
            case 4 -> FORMATTER_WITH_UNITS.format(qty >= 1.0E14 ? Math.floor(qty / 1.0E12) : qty / 1.0E12) + "T";
            case 5 -> FORMATTER_WITH_UNITS.format(qty >= 1.0E17 ? Math.floor(qty / 1.0E15) : qty / 1.0E15) + "P";
            case 6 -> FORMATTER_WITH_UNITS.format(qty >= 1.0E20 ? Math.floor(qty / 1.0E18) : qty / 1.0E18) + "E";
            default -> "\u221e";
        };
    }

    public static String format(long qty) {
        return FORMATTER.format(qty);
    }

    static {
        FORMATTER_WITH_UNITS.setRoundingMode(RoundingMode.FLOOR);
    }
}

