/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.upgrade;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.refinedmods.refinedstorage.common.content.Items;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class UpgradeWithEnchantedBookRecipe
extends ShapedRecipe {
    public static final MapCodec<UpgradeWithEnchantedBookRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Enchantment.CODEC.fieldOf("enchantment").forGetter(UpgradeWithEnchantedBookRecipe::getEnchantment), (App)Codec.INT.fieldOf("level").orElse((Object)1).forGetter(UpgradeWithEnchantedBookRecipe::getEnchantmentLevel), (App)ItemStack.CODEC.fieldOf("result").forGetter(UpgradeWithEnchantedBookRecipe::getResultItem)).apply((Applicative)instance, UpgradeWithEnchantedBookRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpgradeWithEnchantedBookRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ENCHANTMENT), UpgradeWithEnchantedBookRecipe::getEnchantment, (StreamCodec)ByteBufCodecs.INT, UpgradeWithEnchantedBookRecipe::getEnchantmentLevel, (StreamCodec)ItemStack.STREAM_CODEC, UpgradeWithEnchantedBookRecipe::getResultItem, UpgradeWithEnchantedBookRecipe::new);
    private final Holder<Enchantment> enchantment;
    private final int level;
    private final ItemStack resultItem;

    UpgradeWithEnchantedBookRecipe(Holder<Enchantment> enchantment, int level, ItemStack resultItem) {
        super("", CraftingBookCategory.MISC, new ShapedRecipePattern(3, 3, NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.INSTANCE.getQuartzEnrichedIron())}), Ingredient.of((ItemStack[])new ItemStack[]{EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(enchantment, level))}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.INSTANCE.getQuartzEnrichedIron())}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.BOOKSHELF)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.INSTANCE.getUpgrade())}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.BOOKSHELF)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.INSTANCE.getQuartzEnrichedIron())}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.INSTANCE.getQuartzEnrichedIron())}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.INSTANCE.getQuartzEnrichedIron())})}), Optional.empty()), resultItem);
        this.enchantment = enchantment;
        this.level = level;
        this.resultItem = resultItem;
    }

    ItemStack getResultItem() {
        return this.resultItem;
    }

    Holder<Enchantment> getEnchantment() {
        return this.enchantment;
    }

    int getEnchantmentLevel() {
        return this.level;
    }

    public boolean matches(CraftingInput craftingContainer, Level theLevel) {
        if (!super.matches(craftingContainer, theLevel)) {
            return false;
        }
        ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)craftingContainer.getItem(1));
        return enchantments.getLevel(this.enchantment) == this.level;
    }
}

