/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.stretching;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.support.stretching.AbstractStretchingScreen;
import com.refinedmods.refinedstorage.common.support.stretching.ScreenSize;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ScreenSizeSideButtonWidget
extends AbstractSideButtonWidget {
    private static final MutableComponent TITLE = IdentifierUtil.createTranslation("gui", "screen_size");
    private static final List<MutableComponent> SUBTEXT_STRETCH = List.of(IdentifierUtil.createTranslation("gui", "screen_size.stretch").withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> SUBTEXT_SMALL = List.of(IdentifierUtil.createTranslation("gui", "screen_size.small").withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> SUBTEXT_MEDIUM = List.of(IdentifierUtil.createTranslation("gui", "screen_size.medium").withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> SUBTEXT_LARGE = List.of(IdentifierUtil.createTranslation("gui", "screen_size.large").withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> SUBTEXT_EXTRA_LARGE = List.of(IdentifierUtil.createTranslation("gui", "screen_size.extra_large").withStyle(ChatFormatting.GRAY));
    private static final ResourceLocation STRETCH = IdentifierUtil.createIdentifier("widget/side_button/screen_size/stretch");
    private static final ResourceLocation SMALL = IdentifierUtil.createIdentifier("widget/side_button/screen_size/small");
    private static final ResourceLocation MEDIUM = IdentifierUtil.createIdentifier("widget/side_button/screen_size/medium");
    private static final ResourceLocation EXTRA_LARGE = IdentifierUtil.createIdentifier("widget/side_button/screen_size/extra_large");

    public ScreenSizeSideButtonWidget(AbstractStretchingScreen<?> stretchingScreen) {
        super(ScreenSizeSideButtonWidget.createPressAction(stretchingScreen));
    }

    private static Button.OnPress createPressAction(AbstractStretchingScreen<?> stretchingScreen) {
        return btn -> {
            Platform.INSTANCE.getConfig().setScreenSize(Platform.INSTANCE.getConfig().getScreenSize().toggle());
            stretchingScreen.init();
        };
    }

    @Override
    protected ResourceLocation getSprite() {
        ScreenSize screenSize = Platform.INSTANCE.getConfig().getScreenSize();
        return switch (screenSize) {
            default -> throw new MatchException(null, null);
            case ScreenSize.STRETCH -> STRETCH;
            case ScreenSize.SMALL -> SMALL;
            case ScreenSize.MEDIUM -> MEDIUM;
            case ScreenSize.LARGE, ScreenSize.EXTRA_LARGE -> EXTRA_LARGE;
        };
    }

    @Override
    protected MutableComponent getTitle() {
        return TITLE;
    }

    @Override
    protected List<MutableComponent> getSubText() {
        ScreenSize screenSize = Platform.INSTANCE.getConfig().getScreenSize();
        return switch (screenSize) {
            default -> throw new MatchException(null, null);
            case ScreenSize.STRETCH -> SUBTEXT_STRETCH;
            case ScreenSize.SMALL -> SUBTEXT_SMALL;
            case ScreenSize.MEDIUM -> SUBTEXT_MEDIUM;
            case ScreenSize.LARGE -> SUBTEXT_LARGE;
            case ScreenSize.EXTRA_LARGE -> SUBTEXT_EXTRA_LARGE;
        };
    }
}

