/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.slotreference;

import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReferenceProvider;
import com.refinedmods.refinedstorage.common.support.slotreference.InventorySlotReferenceProvider;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class CompositeSlotReferenceProvider
implements SlotReferenceProvider {
    private final List<SlotReferenceProvider> providers = new ArrayList<InventorySlotReferenceProvider>(List.of(new InventorySlotReferenceProvider()));

    public void addProvider(SlotReferenceProvider provider) {
        this.providers.add(provider);
    }

    @Override
    public List<SlotReference> find(Player player, Set<Item> validItems) {
        return this.providers.stream().flatMap(p -> p.find(player, validItems).stream()).toList();
    }

    public Optional<SlotReference> findForUse(Player player, Item referenceItem, Set<Item> validItems) {
        List<SlotReference> foundReferences = this.find(player, validItems);
        if (foundReferences.size() > 1) {
            player.sendSystemMessage((Component)IdentifierUtil.createTranslation("item", "network_item.cannot_open_with_shortcut_due_to_duplicate", referenceItem.getDescription()).withStyle(ChatFormatting.RED));
            return Optional.empty();
        }
        if (foundReferences.isEmpty()) {
            player.sendSystemMessage((Component)IdentifierUtil.createTranslation("item", "network_item.cannot_open_because_not_found", referenceItem.getDescription()).withStyle(ChatFormatting.RED));
            return Optional.empty();
        }
        return Optional.of(foundReferences.getFirst());
    }
}

