/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.packet.c2s;

import com.refinedmods.refinedstorage.api.autocrafting.preview.PreviewProvider;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.autocrafting.TimeoutableCancellationToken;
import com.refinedmods.refinedstorage.common.support.packet.PacketContext;
import com.refinedmods.refinedstorage.common.support.packet.s2c.S2CPackets;
import com.refinedmods.refinedstorage.common.support.resource.ResourceCodecs;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;

public record AutocraftingPreviewMaxAmountRequestPacket(PlatformResourceKey resource) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<AutocraftingPreviewMaxAmountRequestPacket> PACKET_TYPE = new CustomPacketPayload.Type(IdentifierUtil.createIdentifier("autocrafting_preview_max_amount_request"));
    public static final StreamCodec<RegistryFriendlyByteBuf, AutocraftingPreviewMaxAmountRequestPacket> STREAM_CODEC = StreamCodec.composite(ResourceCodecs.STREAM_CODEC, AutocraftingPreviewMaxAmountRequestPacket::resource, AutocraftingPreviewMaxAmountRequestPacket::new);

    public static void handle(AutocraftingPreviewMaxAmountRequestPacket packet, PacketContext ctx) {
        AbstractContainerMenu abstractContainerMenu = ctx.getPlayer().containerMenu;
        if (abstractContainerMenu instanceof PreviewProvider) {
            PreviewProvider provider = (PreviewProvider)abstractContainerMenu;
            ServerPlayer player = (ServerPlayer)ctx.getPlayer();
            provider.getMaxAmount(packet.resource, new TimeoutableCancellationToken()).thenAccept(maxAmount -> S2CPackets.sendAutocraftingPreviewMaxAmountResponse(player, maxAmount));
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_TYPE;
    }
}

