/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.amount;

import com.refinedmods.refinedstorage.common.support.amount.AmountOperations;
import com.refinedmods.refinedstorage.common.util.MathUtil;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class LongAmountOperations
implements AmountOperations<Long> {
    public static final AmountOperations<Long> INSTANCE = new LongAmountOperations();

    private LongAmountOperations() {
    }

    @Override
    public String format(Long value) {
        return String.valueOf(value);
    }

    @Override
    public Optional<Long> parse(String value) {
        try {
            return Optional.of(Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<Long> validate(Long amount, @Nullable Long minAmount, @Nullable Long maxAmount) {
        boolean minBoundOk = minAmount == null || amount >= minAmount;
        boolean maxBoundOk = maxAmount == null || amount <= maxAmount;
        return minBoundOk && maxBoundOk ? Optional.of(amount) : Optional.empty();
    }

    @Override
    public Long changeAmount(@Nullable Long current, int delta, @Nullable Long minAmount, @Nullable Long maxAmount) {
        if (current == null) {
            return MathUtil.clamp(delta, Objects.requireNonNullElse(minAmount, Long.MIN_VALUE), Objects.requireNonNullElse(maxAmount, Long.MAX_VALUE));
        }
        return MathUtil.clamp(current + (long)delta, Objects.requireNonNullElse(minAmount, Long.MIN_VALUE), Objects.requireNonNullElse(maxAmount, Long.MAX_VALUE));
    }
}

