/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.support.AbstractBaseContainerMenu;
import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicator;
import com.refinedmods.refinedstorage.common.support.widget.RedstoneModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;

public abstract class AbstractFilterScreen<T extends AbstractBaseContainerMenu>
extends AbstractBaseScreen<T> {
    public static final ResourceLocation TEXTURE = IdentifierUtil.createIdentifier("textures/gui/generic_filter.png");

    protected AbstractFilterScreen(T menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.inventoryLabelY = 42;
        this.imageWidth = this.hasUpgrades() ? 210 : 176;
        this.imageHeight = 137;
    }

    protected boolean hasUpgrades() {
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.addSideButton(new RedstoneModeSideButtonWidget(((AbstractBaseContainerMenu)this.getMenu()).getProperty(PropertyTypes.REDSTONE_MODE)));
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }

    public static boolean renderExportingIndicators(GuiGraphics graphics, int leftPos, int topPos, int mouseX, int mouseY, int indicators, IntFunction<ExportingIndicator> indicatorProvider) {
        for (int i = 0; i < indicators; ++i) {
            boolean hovering;
            ExportingIndicator indicator = indicatorProvider.apply(i);
            int xx = leftPos + 7 + i * 18 + 18 - 10 + 1;
            int yy = topPos + 19 + 18 - 10 + 1;
            ResourceLocation sprite = indicator.getSprite();
            if (sprite != null) {
                graphics.pose().pushPose();
                graphics.pose().translate(0.0f, 0.0f, 300.0f);
                graphics.blitSprite(sprite, xx, yy, 10, 10);
                graphics.pose().popPose();
            }
            boolean bl = hovering = mouseX >= xx && mouseX <= xx + 10 && mouseY >= yy && mouseY <= yy + 10;
            if (indicator == ExportingIndicator.NONE || !hovering) continue;
            Platform.INSTANCE.renderTooltip(graphics, List.of(ClientTooltipComponent.create((FormattedCharSequence)indicator.getTooltip().getVisualOrderText())), mouseX, mouseY);
            return true;
        }
        return false;
    }
}

