/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.content.BlockConstants;
import com.refinedmods.refinedstorage.common.networking.CableConnections;
import com.refinedmods.refinedstorage.common.support.AbstractCableLikeBlockEntity;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.CableShapes;
import com.refinedmods.refinedstorage.common.support.direction.DefaultDirectionType;
import com.refinedmods.refinedstorage.common.support.direction.DirectionType;
import com.refinedmods.refinedstorage.common.util.PlatformUtil;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractDirectionalCableBlock
extends AbstractDirectionalBlock<Direction>
implements SimpleWaterloggedBlock {
    private final ConcurrentHashMap<DirectionalCacheShapeCacheKey, VoxelShape> shapeCache;

    protected AbstractDirectionalCableBlock(ConcurrentHashMap<DirectionalCacheShapeCacheKey, VoxelShape> shapeCache) {
        super(BlockConstants.CABLE_PROPERTIES);
        this.shapeCache = shapeCache;
    }

    @Override
    protected DirectionType<Direction> getDirectionType() {
        return DefaultDirectionType.FACE_CLICKED;
    }

    @Override
    protected BlockState getDefaultState() {
        return (BlockState)super.getDefaultState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) == false;
    }

    public FluidState getFluidState(BlockState state) {
        return Boolean.TRUE.equals(state.getValue((Property)BlockStateProperties.WATERLOGGED)) ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractCableLikeBlockEntity) {
            AbstractCableLikeBlockEntity cable = (AbstractCableLikeBlockEntity)blockEntity;
            cable.updateConnections();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                PlatformUtil.sendBlockUpdateToClient((Level)serverLevel, pos);
            }
        }
        if (level.isClientSide()) {
            Platform.INSTANCE.requestModelDataUpdateOnClient(level, pos, false);
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof AbstractCableLikeBlockEntity)) {
            return Shapes.block();
        }
        AbstractCableLikeBlockEntity cable = (AbstractCableLikeBlockEntity)blockEntity;
        CableConnections connections = cable.getConnections();
        Direction direction = (Direction)this.getDirection(state);
        if (direction == null) {
            return CableShapes.getShape(connections);
        }
        DirectionalCacheShapeCacheKey directionalCacheKey = new DirectionalCacheShapeCacheKey(connections, direction);
        return this.shapeCache.computeIfAbsent(directionalCacheKey, this::computeShape);
    }

    private VoxelShape computeShape(DirectionalCacheShapeCacheKey cacheKey) {
        return Shapes.or((VoxelShape)CableShapes.getShape(cacheKey.connections), (VoxelShape)this.getExtensionShape(cacheKey.direction));
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractCableLikeBlockEntity) {
            AbstractCableLikeBlockEntity cable = (AbstractCableLikeBlockEntity)blockEntity;
            cable.updateConnections();
            PlatformUtil.sendBlockUpdateToClient(level, pos);
        }
    }

    @Override
    @Nullable
    protected VoxelShape getScreenOpenableShape(BlockState state) {
        Direction direction = (Direction)this.getDirection(state);
        if (direction == null) {
            return Shapes.empty();
        }
        return this.getExtensionShape(direction);
    }

    protected abstract VoxelShape getExtensionShape(Direction var1);

    protected record DirectionalCacheShapeCacheKey(CableConnections connections, Direction direction) {
    }
}

