/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.portablegrid;

import com.refinedmods.refinedstorage.api.autocrafting.calculation.CancellationToken;
import com.refinedmods.refinedstorage.api.autocrafting.preview.Preview;
import com.refinedmods.refinedstorage.api.autocrafting.preview.TreePreview;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.api.network.impl.node.grid.GridWatcherManager;
import com.refinedmods.refinedstorage.api.network.impl.node.grid.GridWatcherManagerImpl;
import com.refinedmods.refinedstorage.api.network.node.grid.EmptyGridOperations;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.api.network.node.grid.GridWatcher;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.NoopStorage;
import com.refinedmods.refinedstorage.api.storage.StateTrackedStorage;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.StorageState;
import com.refinedmods.refinedstorage.api.storage.TrackedResourceAmount;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.grid.Grid;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.refinedmods.refinedstorage.common.storage.DiskInventory;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGridOperations;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGridStorage;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

class PortableGrid
implements Grid {
    private final EnergyStorage energyStorage;
    private final DiskInventory diskInventory;
    private final GridWatcherManager watchers = new GridWatcherManagerImpl();
    private final StateTrackedStorage.Listener diskListener;
    @Nullable
    private PortableGridStorage storage;

    PortableGrid(EnergyStorage energyStorage, DiskInventory diskInventory, StateTrackedStorage.Listener diskListener) {
        this.energyStorage = energyStorage;
        this.diskInventory = diskInventory;
        this.diskListener = diskListener;
    }

    void updateStorage() {
        if (this.storage != null) {
            this.watchers.detachAll(this.storage.getRootStorage());
        }
        this.storage = this.diskInventory.resolve(0).map(diskStorage -> new StateTrackedStorage((Storage)diskStorage, this.diskListener)).map(PortableGridStorage::new).orElse(null);
        this.watchers.attachAll(this.getRootStorage());
    }

    void activeChanged(boolean active) {
        this.watchers.activeChanged(active);
    }

    StorageState getStorageState() {
        if (this.storage == null) {
            return StorageState.NONE;
        }
        if (!this.isGridActive()) {
            return StorageState.INACTIVE;
        }
        return this.storage.getState();
    }

    @Override
    public void addWatcher(GridWatcher watcher, Class<? extends Actor> actorType) {
        this.energyStorage.extract(Platform.INSTANCE.getConfig().getPortableGrid().getOpenEnergyUsage(), Action.EXECUTE);
        this.watchers.addWatcher(watcher, actorType, this.getRootStorage());
    }

    @Override
    public void removeWatcher(GridWatcher watcher) {
        this.watchers.removeWatcher(watcher, this.getRootStorage());
    }

    @Nullable
    private RootStorage getRootStorage() {
        return this.storage != null ? this.storage.getRootStorage() : null;
    }

    @Override
    public Storage getItemStorage() {
        if (this.storage == null) {
            return new NoopStorage();
        }
        return this.storage.getRootStorage();
    }

    @Override
    public boolean isGridActive() {
        return this.energyStorage.getStored() > 0L && this.storage != null;
    }

    @Override
    public List<TrackedResourceAmount> getResources(Class<? extends Actor> actorType) {
        if (this.storage == null) {
            return Collections.emptyList();
        }
        RootStorage rootStorage = this.storage.getRootStorage();
        return rootStorage.getAll().stream().map(resource -> new TrackedResourceAmount((ResourceAmount)resource, rootStorage.findTrackedResourceByActorType(resource.resource(), actorType).orElse(null))).toList();
    }

    @Override
    public Set<PlatformResourceKey> getAutocraftableResources() {
        return Collections.emptySet();
    }

    @Override
    public GridOperations createOperations(ResourceType resourceType, ServerPlayer player) {
        if (this.storage == null) {
            return EmptyGridOperations.INSTANCE;
        }
        RootStorage rootStorage = this.storage.getRootStorage();
        GridOperations operations = resourceType.createGridOperations(rootStorage, new PlayerActor((Player)player));
        return new PortableGridOperations(operations, this.energyStorage);
    }

    @Override
    public boolean canMenuStayOpen(Player player) {
        return true;
    }

    @Override
    public CompletableFuture<Optional<Preview>> getPreview(ResourceKey resource, long amount, CancellationToken cancellationToken) {
        return CompletableFuture.completedFuture(Optional.empty());
    }

    @Override
    public CompletableFuture<Optional<TreePreview>> getTreePreview(ResourceKey resource, long amount, CancellationToken cancellationToken) {
        return CompletableFuture.completedFuture(Optional.empty());
    }

    @Override
    public CompletableFuture<Long> getMaxAmount(ResourceKey resource, CancellationToken cancellationToken) {
        return CompletableFuture.completedFuture(0L);
    }

    @Override
    public CompletableFuture<Optional<TaskId>> startTask(ResourceKey resource, long amount, Actor actor, boolean notify, CancellationToken cancellationToken) {
        return CompletableFuture.completedFuture(Optional.empty());
    }
}

