/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.diskinterface;

import com.refinedmods.refinedstorage.api.network.impl.node.storagetransfer.StorageTransferMode;
import com.refinedmods.refinedstorage.common.storage.FilterModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.storage.diskinterface.DiskInterfaceContainerMenu;
import com.refinedmods.refinedstorage.common.storage.diskinterface.DiskInterfacePropertyTypes;
import com.refinedmods.refinedstorage.common.storage.diskinterface.TransferModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.widget.FuzzyModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.RedstoneModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class DiskInterfaceScreen
extends AbstractBaseScreen<DiskInterfaceContainerMenu> {
    private static final ResourceLocation TEXTURE = IdentifierUtil.createIdentifier("textures/gui/disk_interface.png");
    private static final MutableComponent IN_TEXT = IdentifierUtil.createTranslation("gui", "disk_interface.in");
    private static final MutableComponent OUT_TEXT = IdentifierUtil.createTranslation("gui", "disk_interface.out");

    public DiskInterfaceScreen(DiskInterfaceContainerMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.inventoryLabelY = 117;
        this.imageWidth = 211;
        this.imageHeight = 211;
    }

    @Override
    protected void init() {
        super.init();
        this.addSideButton(new RedstoneModeSideButtonWidget(((DiskInterfaceContainerMenu)this.getMenu()).getProperty(PropertyTypes.REDSTONE_MODE)));
        this.addSideButton(new TransferModeSideButtonWidget(((DiskInterfaceContainerMenu)this.getMenu()).getProperty(DiskInterfacePropertyTypes.TRANSFER_MODE)));
        this.addSideButton(new FilterModeSideButtonWidget(((DiskInterfaceContainerMenu)this.getMenu()).getProperty(PropertyTypes.FILTER_MODE), (Component)IdentifierUtil.createTranslation("gui", "disk_interface.filter_mode.allow.help"), (Component)IdentifierUtil.createTranslation("gui", "disk_interface.filter_mode.block.help")));
        this.addSideButton(new FuzzyModeSideButtonWidget(((DiskInterfaceContainerMenu)this.getMenu()).getProperty(PropertyTypes.FUZZY_MODE), () -> ((DiskInterfaceContainerMenu)this.getMenu()).getProperty(DiskInterfacePropertyTypes.TRANSFER_MODE).getValue() == StorageTransferMode.EXTRACT_FROM_NETWORK ? FuzzyModeSideButtonWidget.Type.EXTRACTING_STORAGE_NETWORK : FuzzyModeSideButtonWidget.Type.EXTRACTING_SOURCE));
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int x, int y) {
        super.renderLabels(graphics, x, y);
        graphics.drawString(this.font, (Component)IN_TEXT, 43, 45, 0x404040, false);
        graphics.drawString(this.font, (Component)OUT_TEXT, 115, 45, 0x404040, false);
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }
}

