/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.InsertableStorage;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class BucketPlayerInventoryInsertableStorage
implements InsertableStorage {
    private static final ItemStack EMPTY_BUCKET_STACK = new ItemStack((ItemLike)Items.BUCKET);
    private static final ItemResource EMPTY_BUCKET_RESOURCE = ItemResource.ofItemStack(EMPTY_BUCKET_STACK);
    private final Inventory playerInventory;
    private final Storage emptyBucketStorage;
    private final boolean mayDropFilledBucket;

    public BucketPlayerInventoryInsertableStorage(Inventory playerInventory, Storage emptyBucketStorage, boolean mayDropFilledBucket) {
        this.playerInventory = playerInventory;
        this.emptyBucketStorage = emptyBucketStorage;
        this.mayDropFilledBucket = mayDropFilledBucket;
    }

    @Override
    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        if (!(resource instanceof FluidResource)) {
            return 0L;
        }
        FluidResource fluidResource = (FluidResource)resource;
        if (amount != Platform.INSTANCE.getBucketAmount()) {
            return 0L;
        }
        ResourceAmount toFill = new ResourceAmount(fluidResource, amount);
        return Platform.INSTANCE.fillContainer(EMPTY_BUCKET_STACK, toFill).map(result -> this.insert(result.container(), amount, action, actor)).orElse(0L);
    }

    private long insert(ItemStack filledBucketStack, long amount, Action action, Actor actor) {
        if (this.extractBucketFromInventory(action)) {
            return this.insert(filledBucketStack, amount, action, this::returnBucketToInventory);
        }
        if (this.extractBucketFromStorage(action, actor)) {
            return this.insert(filledBucketStack, amount, action, () -> this.returnBucketToStorage(actor));
        }
        return 0L;
    }

    private long insert(ItemStack filledBucketStack, long amount, Action action, Runnable rollbackAction) {
        if (action == Action.EXECUTE && !this.playerInventory.add(filledBucketStack)) {
            if (this.mayDropFilledBucket) {
                this.playerInventory.player.drop(filledBucketStack, false);
            } else {
                rollbackAction.run();
                return 0L;
            }
        }
        return amount;
    }

    private boolean extractBucketFromInventory(Action action) {
        for (int i = 0; i < this.playerInventory.getContainerSize(); ++i) {
            ItemStack stack = this.playerInventory.getItem(i);
            if (stack.getItem() != Items.BUCKET) continue;
            if (action == Action.EXECUTE) {
                this.playerInventory.removeItem(i, 1);
            }
            return true;
        }
        return false;
    }

    private void returnBucketToInventory() {
        this.playerInventory.add(EMPTY_BUCKET_STACK);
    }

    private boolean extractBucketFromStorage(Action action, Actor actor) {
        return this.emptyBucketStorage.extract(EMPTY_BUCKET_RESOURCE, 1L, action, actor) == 1L;
    }

    private void returnBucketToStorage(Actor actor) {
        this.emptyBucketStorage.insert(EMPTY_BUCKET_RESOURCE, 1L, Action.EXECUTE, actor);
    }
}

