/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.importer;

import com.refinedmods.refinedstorage.common.content.BlockColorMap;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.BlockEntityProvider;
import com.refinedmods.refinedstorage.common.content.Blocks;
import com.refinedmods.refinedstorage.common.importer.AbstractImporterBlockEntity;
import com.refinedmods.refinedstorage.common.support.AbstractBlockEntityTicker;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalCableBlock;
import com.refinedmods.refinedstorage.common.support.BaseBlockItem;
import com.refinedmods.refinedstorage.common.support.BlockItemProvider;
import com.refinedmods.refinedstorage.common.support.ColorableBlock;
import com.refinedmods.refinedstorage.common.support.DirectionalCableBlockShapes;
import com.refinedmods.refinedstorage.common.support.NetworkNodeBlockItem;
import com.refinedmods.refinedstorage.common.support.network.NetworkNodeBlockEntityTicker;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ImporterBlock
extends AbstractDirectionalCableBlock
implements ColorableBlock<ImporterBlock, BaseBlockItem>,
EntityBlock,
BlockItemProvider<BaseBlockItem> {
    private static final Component HELP = IdentifierUtil.createTranslation("item", "importer.help");
    private static final ConcurrentHashMap<AbstractDirectionalCableBlock.DirectionalCacheShapeCacheKey, VoxelShape> SHAPE_CACHE = new ConcurrentHashMap();
    private static final AbstractBlockEntityTicker<AbstractImporterBlockEntity> TICKER = new NetworkNodeBlockEntityTicker(BlockEntities.INSTANCE::getImporter);
    private final DyeColor color;
    private final MutableComponent name;
    private final BlockEntityProvider<AbstractImporterBlockEntity> blockEntityProvider;

    public ImporterBlock(DyeColor color, MutableComponent name, BlockEntityProvider<AbstractImporterBlockEntity> blockEntityProvider) {
        super(SHAPE_CACHE);
        this.color = color;
        this.name = name;
        this.blockEntityProvider = blockEntityProvider;
    }

    @Override
    public DyeColor getColor() {
        return this.color;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.blockEntityProvider.create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return TICKER.get(level, type);
    }

    @Override
    public BlockColorMap<ImporterBlock, BaseBlockItem> getBlockColorMap() {
        return Blocks.INSTANCE.getImporter();
    }

    @Override
    protected VoxelShape getExtensionShape(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> DirectionalCableBlockShapes.IMPORTER_NORTH;
            case Direction.EAST -> DirectionalCableBlockShapes.IMPORTER_EAST;
            case Direction.SOUTH -> DirectionalCableBlockShapes.IMPORTER_SOUTH;
            case Direction.WEST -> DirectionalCableBlockShapes.IMPORTER_WEST;
            case Direction.UP -> DirectionalCableBlockShapes.IMPORTER_UP;
            case Direction.DOWN -> DirectionalCableBlockShapes.IMPORTER_DOWN;
        };
    }

    public MutableComponent getName() {
        return this.name;
    }

    @Override
    public BaseBlockItem createBlockItem() {
        return new NetworkNodeBlockItem(this, HELP);
    }
}

