/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.iface;

import com.refinedmods.refinedstorage.api.network.impl.node.iface.InterfaceNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.iface.InterfaceTransferResult;
import com.refinedmods.refinedstorage.api.network.impl.node.iface.externalstorage.InterfaceExternalStorageProvider;
import com.refinedmods.refinedstorage.api.network.impl.node.iface.externalstorage.InterfaceExternalStorageProviderImpl;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.iface.ExportedResourcesContainer;
import com.refinedmods.refinedstorage.common.iface.InterfaceContainerMenu;
import com.refinedmods.refinedstorage.common.iface.InterfaceData;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicator;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicators;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class InterfaceBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<InterfaceNetworkNode>
implements NetworkNodeExtendedMenuProvider<InterfaceData>,
BlockEntityWithDrops {
    private static final String TAG_EXPORT_ITEMS = "ei";
    private static final int EXPORT_SLOTS = 9;
    private static final String TAG_UPGRADES = "upgr";
    private final UpgradeContainer upgradeContainer;
    private final FilterWithFuzzyMode filter;
    private final ExportedResourcesContainer exportedResources;
    private final Container exportedResourcesAsContainer;
    private final InterfaceExternalStorageProvider externalStorageProvider;

    public InterfaceBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.INSTANCE.getInterface(), pos, state, new InterfaceNetworkNode(Platform.INSTANCE.getConfig().getInterface().getEnergyUsage()));
        ((InterfaceNetworkNode)this.mainNetworkNode).setTransferQuotaProvider(InterfaceBlockEntity::getTransferQuota);
        this.upgradeContainer = new UpgradeContainer(1, UpgradeDestinations.INTERFACE, (c, upgradeEnergyUsage) -> {
            long baseEnergyUsage = Platform.INSTANCE.getConfig().getInterface().getEnergyUsage();
            ((InterfaceNetworkNode)this.mainNetworkNode).setEnergyUsage(baseEnergyUsage + upgradeEnergyUsage);
            boolean autocrafting = c.has(Items.INSTANCE.getAutocraftingUpgrade());
            ((InterfaceNetworkNode)this.mainNetworkNode).setOnMissingResources(autocrafting ? new InterfaceNetworkNode.AutocraftOnMissingResources() : InterfaceNetworkNode.OnMissingResources.EMPTY);
            this.setChanged();
        });
        this.filter = FilterWithFuzzyMode.create(InterfaceBlockEntity.createFilterContainer(), () -> ((InterfaceBlockEntity)this).setChanged());
        this.exportedResources = InterfaceBlockEntity.createExportedResourcesContainer(this.filter);
        this.exportedResources.setListener(() -> ((InterfaceBlockEntity)this).setChanged());
        ((InterfaceNetworkNode)this.mainNetworkNode).setExportState(this.exportedResources);
        this.exportedResourcesAsContainer = this.exportedResources.toItemContainer();
        this.externalStorageProvider = new InterfaceExternalStorageProviderImpl((InterfaceNetworkNode)this.mainNetworkNode);
    }

    static ResourceContainer createFilterContainer() {
        return new ResourceContainerImpl(9, InterfaceBlockEntity::getTransferQuota, RefinedStorageApi.INSTANCE.getItemResourceFactory(), RefinedStorageApi.INSTANCE.getAlternativeResourceFactories());
    }

    static ResourceContainer createFilterContainer(InterfaceData interfaceData) {
        ResourceContainer filterContainer = InterfaceBlockEntity.createFilterContainer();
        ResourceContainerData resourceContainerData = interfaceData.filterContainerData();
        for (int i = 0; i < resourceContainerData.resources().size(); ++i) {
            int ii = i;
            resourceContainerData.resources().get(i).ifPresent(resource -> filterContainer.set(ii, (ResourceAmount)resource));
        }
        return filterContainer;
    }

    static ExportedResourcesContainer createExportedResourcesContainer(FilterWithFuzzyMode filter) {
        return new ExportedResourcesContainer(9, filter);
    }

    static ResourceContainer createExportedResourcesContainer(InterfaceData interfaceData, FilterWithFuzzyMode filter) {
        ExportedResourcesContainer exportedResourcesContainer = InterfaceBlockEntity.createExportedResourcesContainer(filter);
        ResourceContainerData resourceContainerData = interfaceData.exportedResourcesContainerData();
        for (int i = 0; i < resourceContainerData.resources().size(); ++i) {
            int ii = i;
            resourceContainerData.resources().get(i).ifPresent(resource -> exportedResourcesContainer.set(ii, (ResourceAmount)resource));
        }
        return exportedResourcesContainer;
    }

    static long getTransferQuota(ResourceKey resource) {
        if (resource instanceof PlatformResourceKey) {
            PlatformResourceKey platformResource = (PlatformResourceKey)resource;
            return platformResource.getInterfaceExportLimit();
        }
        return 0L;
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(TAG_EXPORT_ITEMS, (Tag)this.exportedResources.toTag(provider));
        tag.put(TAG_UPGRADES, (Tag)ContainerUtil.write((Container)this.upgradeContainer, provider));
    }

    @Override
    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
        this.filter.save(tag, provider);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains(TAG_EXPORT_ITEMS)) {
            this.exportedResources.fromTag(tag.getCompound(TAG_EXPORT_ITEMS), provider);
        }
        if (tag.contains(TAG_UPGRADES)) {
            ContainerUtil.read(tag.getCompound(TAG_UPGRADES), (Container)this.upgradeContainer, provider);
        }
        super.loadAdditional(tag, provider);
    }

    @Override
    public List<ItemStack> getUpgrades() {
        return this.upgradeContainer.getUpgrades();
    }

    @Override
    public boolean addUpgrade(ItemStack upgradeStack) {
        return this.upgradeContainer.addUpgrade(upgradeStack);
    }

    @Override
    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
        this.filter.load(tag, provider);
    }

    boolean isFuzzyMode() {
        return this.filter.isFuzzyMode();
    }

    void setFuzzyMode(boolean fuzzyMode) {
        this.filter.setFuzzyMode(fuzzyMode);
    }

    void clearFilters() {
        this.filter.getFilterContainer().clear();
    }

    void setFilters(List<ResourceAmount> filters) {
        for (int i = 0; i < filters.size(); ++i) {
            this.filter.getFilterContainer().set(i, filters.get(i));
        }
    }

    public ExportedResourcesContainer getExportedResources() {
        return this.exportedResources;
    }

    public Container getExportedResourcesAsContainer() {
        return this.exportedResourcesAsContainer;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        return new InterfaceContainerMenu(syncId, player, this, this.filter.getFilterContainer(), this.exportedResources, this.exportedResourcesAsContainer, this.upgradeContainer, this.getExportingIndicators());
    }

    private ExportingIndicators getExportingIndicators() {
        return new ExportingIndicators(this.filter.getFilterContainer(), i -> this.toExportingIndicator(((InterfaceNetworkNode)this.mainNetworkNode).getLastResult(i)), true);
    }

    private ExportingIndicator toExportingIndicator(@Nullable InterfaceTransferResult result) {
        InterfaceTransferResult interfaceTransferResult = result;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"STORAGE_DOES_NOT_ACCEPT_RESOURCE", "RESOURCE_MISSING", "AUTOCRAFTING_STARTED", "AUTOCRAFTING_MISSING_RESOURCES"}, (InterfaceTransferResult)interfaceTransferResult, n)) {
            case 0 -> ExportingIndicator.DESTINATION_DOES_NOT_ACCEPT_RESOURCE;
            case 1 -> ExportingIndicator.RESOURCE_MISSING;
            case 2 -> ExportingIndicator.AUTOCRAFTING_WAS_STARTED;
            case 3 -> ExportingIndicator.AUTOCRAFTING_MISSING_RESOURCES;
            default -> ExportingIndicator.NONE;
        };
    }

    @Override
    public InterfaceData getMenuData() {
        return new InterfaceData(ResourceContainerData.of(this.filter.getFilterContainer()), ResourceContainerData.of(this.exportedResources), this.getExportingIndicators().getAll());
    }

    @Override
    public StreamEncoder<RegistryFriendlyByteBuf, InterfaceData> getMenuCodec() {
        return InterfaceData.STREAM_CODEC;
    }

    public Component getName() {
        return this.overrideName((Component)ContentNames.INTERFACE);
    }

    @Override
    public final NonNullList<ItemStack> getDrops() {
        NonNullList drops = NonNullList.create();
        for (int i = 0; i < this.exportedResourcesAsContainer.getContainerSize(); ++i) {
            drops.add((Object)this.exportedResourcesAsContainer.getItem(i));
        }
        drops.addAll(this.upgradeContainer.getDrops());
        return drops;
    }

    InterfaceExternalStorageProvider getExternalStorageProvider() {
        return this.externalStorageProvider;
    }

    InterfaceNetworkNode getInterface() {
        return (InterfaceNetworkNode)this.mainNetworkNode;
    }
}

