/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid.strategy;

import com.refinedmods.refinedstorage.api.network.node.grid.GridInsertMode;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridInsertionStrategy;
import java.util.Collections;
import java.util.List;

public class CompositeGridInsertionStrategy
implements GridInsertionStrategy {
    private final GridInsertionStrategy defaultStrategy;
    private final List<GridInsertionStrategy> alternativeStrategies;

    public CompositeGridInsertionStrategy(GridInsertionStrategy defaultStrategy, List<GridInsertionStrategy> alternativeStrategies) {
        this.defaultStrategy = defaultStrategy;
        this.alternativeStrategies = Collections.unmodifiableList(alternativeStrategies);
    }

    @Override
    public boolean onInsert(GridInsertMode insertMode, boolean tryAlternatives) {
        if (tryAlternatives) {
            for (GridInsertionStrategy alternativeHandler : this.alternativeStrategies) {
                if (!alternativeHandler.onInsert(insertMode, true)) continue;
                return true;
            }
        }
        return this.defaultStrategy.onInsert(insertMode, tryAlternatives);
    }

    @Override
    public boolean onTransfer(int slotIndex) {
        return this.defaultStrategy.onTransfer(slotIndex);
    }
}

