/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid;

import com.refinedmods.refinedstorage.api.network.impl.node.grid.GridWatcherManager;
import com.refinedmods.refinedstorage.api.network.node.grid.GridExtractMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridInsertMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.ExtractableStorage;
import com.refinedmods.refinedstorage.api.storage.InsertableStorage;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.support.network.item.NetworkItemContext;

class WirelessGridOperations
implements GridOperations {
    private final GridOperations delegate;
    private final NetworkItemContext context;
    private final GridWatcherManager watchers;

    WirelessGridOperations(GridOperations delegate, NetworkItemContext context, GridWatcherManager watchers) {
        this.delegate = delegate;
        this.context = context;
        this.watchers = watchers;
    }

    @Override
    public boolean extract(ResourceKey resource, GridExtractMode extractMode, InsertableStorage destination) {
        boolean success = this.delegate.extract(resource, extractMode, destination);
        if (success) {
            this.drain(Platform.INSTANCE.getConfig().getWirelessGrid().getExtractEnergyUsage());
        }
        return success;
    }

    @Override
    public boolean insert(ResourceKey resource, GridInsertMode insertMode, ExtractableStorage source) {
        boolean success = this.delegate.insert(resource, insertMode, source);
        if (success) {
            this.drain(Platform.INSTANCE.getConfig().getWirelessGrid().getInsertEnergyUsage());
        }
        return success;
    }

    private void drain(long amount) {
        boolean wasActive = this.context.isActive();
        this.context.drainEnergy(amount);
        boolean isActive = this.context.isActive();
        if (wasActive != isActive) {
            this.watchers.activeChanged(isActive);
        }
    }
}

