/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.controller;

import com.refinedmods.refinedstorage.common.content.Menus;
import com.refinedmods.refinedstorage.common.controller.ControllerBlockEntity;
import com.refinedmods.refinedstorage.common.controller.ControllerData;
import com.refinedmods.refinedstorage.common.support.AbstractBaseContainerMenu;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.support.energy.EnergyContainerMenu;
import com.refinedmods.refinedstorage.common.support.energy.EnergyInfo;
import java.util.function.Predicate;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ControllerContainerMenu
extends AbstractBaseContainerMenu
implements EnergyContainerMenu {
    private final EnergyInfo energyInfo;
    private final Predicate<Player> stillValid;

    public ControllerContainerMenu(int syncId, Inventory playerInventory, ControllerData controllerData) {
        super(Menus.INSTANCE.getController(), syncId);
        this.addPlayerInventory(playerInventory, 8, 107);
        this.energyInfo = EnergyInfo.forClient(playerInventory.player, controllerData.stored(), controllerData.capacity());
        this.registerProperty(new ClientProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, RedstoneMode.IGNORE));
        this.stillValid = p -> true;
    }

    ControllerContainerMenu(int syncId, Inventory playerInventory, ControllerBlockEntity controller, Player player) {
        super(Menus.INSTANCE.getController(), syncId);
        this.energyInfo = EnergyInfo.forServer(player, controller::getActualStored, controller::getActualCapacity);
        this.addPlayerInventory(playerInventory, 8, 107);
        this.registerProperty(new ServerProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, controller::getRedstoneMode, controller::setRedstoneMode));
        this.stillValid = p -> Container.stillValidBlockEntity((BlockEntity)controller, (Player)p);
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        this.energyInfo.detectChanges();
    }

    public boolean stillValid(Player player) {
        return this.stillValid.test(player);
    }

    @Override
    public EnergyInfo getEnergyInfo() {
        return this.energyInfo;
    }
}

