/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.content;

import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;

public class ColorMap<T> {
    protected final DyeColor defaultColor;
    private final Map<DyeColor, Supplier<T>> map = new EnumMap<DyeColor, Supplier<T>>(DyeColor.class);
    private final ResourceLocation baseId;

    public ColorMap(ResourceLocation baseId, DyeColor defaultColor) {
        this.baseId = Objects.requireNonNull(baseId);
        this.defaultColor = Objects.requireNonNull(defaultColor);
    }

    public boolean isDefaultColor(DyeColor color) {
        return this.defaultColor == color;
    }

    protected final void putAll(Function<DyeColor, Supplier<T>> factory) {
        for (DyeColor color : DyeColor.values()) {
            this.map.put(color, factory.apply(color));
        }
    }

    protected final ResourceLocation getId(DyeColor color) {
        if (color == this.defaultColor) {
            return this.baseId;
        }
        return ResourceLocation.fromNamespaceAndPath((String)this.baseId.getNamespace(), (String)(color.getName() + "_" + this.baseId.getPath()));
    }

    public void forEach(ColoredConsumer<T> consumer) {
        this.map.entrySet().stream().sorted(new ColoredSorter(this.defaultColor)).forEach((? super T entry) -> consumer.accept((DyeColor)entry.getKey(), this.getId((DyeColor)entry.getKey()), (Supplier)entry.getValue()));
    }

    public T get(DyeColor color) {
        return this.map.get(color).get();
    }

    public T getDefault() {
        return this.get(this.defaultColor);
    }

    public Collection<T> values() {
        return this.map.values().stream().map(Supplier::get).toList();
    }

    private record ColoredSorter<T>(DyeColor defaultColor) implements Comparator<Map.Entry<DyeColor, T>>
    {
        @Override
        public int compare(Map.Entry<DyeColor, T> entry1, Map.Entry<DyeColor, T> entry2) {
            return this.getId(entry1) - this.getId(entry2);
        }

        private int getId(Map.Entry<DyeColor, T> entry) {
            return (entry.getKey().getId() - this.defaultColor.getId() + 16) % 16;
        }
    }

    @FunctionalInterface
    public static interface ColoredConsumer<T> {
        public void accept(DyeColor var1, ResourceLocation var2, Supplier<T> var3);
    }
}

