/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.patterngrid;

import com.refinedmods.refinedstorage.common.autocrafting.VanillaConstants;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridRenderer;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternType;
import com.refinedmods.refinedstorage.common.support.widget.ScrollbarWidget;
import com.refinedmods.refinedstorage.common.util.ClientPlatformUtil;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.StonecutterRecipe;

class StonecutterPatternGridRenderer
implements PatternGridRenderer {
    private static final ResourceLocation SPRITE = IdentifierUtil.createIdentifier("pattern_grid/stonecutter");
    @Nullable
    private ScrollbarWidget scrollbar;
    private final PatternGridContainerMenu menu;
    private final int leftPos;
    private final int x;
    private final int y;

    StonecutterPatternGridRenderer(PatternGridContainerMenu menu, int leftPos, int x, int y) {
        this.menu = menu;
        this.leftPos = leftPos;
        this.x = x;
        this.y = y;
    }

    @Override
    public void addWidgets(Consumer<AbstractWidget> widgets, Consumer<AbstractWidget> renderables) {
        this.scrollbar = StonecutterPatternGridRenderer.createStonecutterScrollbar(this.menu, this.x, this.y);
        this.updateScrollbarMaxOffset();
        widgets.accept(this.scrollbar);
    }

    private static ScrollbarWidget createStonecutterScrollbar(PatternGridContainerMenu menu, int x, int y) {
        ScrollbarWidget scrollbar = new ScrollbarWidget(x + 107, y + 9, ScrollbarWidget.Type.NORMAL, 54);
        scrollbar.visible = StonecutterPatternGridRenderer.isScrollbarVisible(menu);
        return scrollbar;
    }

    private void updateScrollbarMaxOffset() {
        if (this.scrollbar == null) {
            return;
        }
        int items = this.menu.getStonecutterRecipes().size();
        int rows = Math.ceilDiv(items, 4);
        int maxOffset = rows - 3;
        int maxOffsetCorrected = maxOffset * (this.scrollbar.isSmoothScrolling() ? 18 : 1);
        this.scrollbar.setMaxOffset(maxOffsetCorrected);
        this.scrollbar.setEnabled(maxOffsetCorrected > 0);
    }

    @Override
    public void tick() {
        this.updateScrollbarMaxOffset();
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.scrollbar != null) {
            this.scrollbar.render(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public int getClearButtonX() {
        return this.leftPos + 130;
    }

    @Override
    public int getClearButtonY() {
        return this.y + 8;
    }

    @Override
    public void renderBackground(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.blitSprite(SPRITE, this.x + 4, this.y + 4 + 4, 116, 56);
        graphics.enableScissor(this.x + 40, this.y + 9, this.x + 40 + 64, this.y + 9 + 54);
        boolean isOverArea = this.isOverStonecutterArea(mouseX, mouseY);
        for (int i = 0; i < this.menu.getStonecutterRecipes().size(); ++i) {
            boolean hovering;
            RecipeHolder<StonecutterRecipe> recipe = this.menu.getStonecutterRecipes().get(i);
            int xx = this.getRecipeX(this.x, i);
            int row = i / 4;
            int yy = this.getRecipeY(this.y, row);
            if (yy < this.y + 9 - 18 || yy > this.y + 9 + 54) continue;
            boolean bl = hovering = mouseX >= xx && mouseY >= yy && mouseX < xx + 16 && mouseY < yy + 18;
            ResourceLocation buttonSprite = i == this.menu.getStonecutterSelectedRecipe() ? VanillaConstants.STONECUTTER_RECIPE_SELECTED_SPRITE : (isOverArea && hovering ? VanillaConstants.STONECUTTER_RECIPE_HIGHLIGHTED_SPRITE : VanillaConstants.STONECUTTER_RECIPE_SPRITE);
            graphics.blitSprite(buttonSprite, xx, yy, 16, 18);
            graphics.renderItem(((StonecutterRecipe)recipe.value()).getResultItem((HolderLookup.Provider)Objects.requireNonNull(ClientPlatformUtil.getClientLevel()).registryAccess()), xx, yy + 1);
        }
        graphics.disableScissor();
    }

    @Override
    public void renderTooltip(Font font, @Nullable Slot hoveredSlot, GuiGraphics graphics, int mouseX, int mouseY) {
        if (!this.isOverStonecutterArea(mouseX, mouseY)) {
            return;
        }
        for (int i = 0; i < this.menu.getStonecutterRecipes().size(); ++i) {
            RecipeHolder<StonecutterRecipe> recipe = this.menu.getStonecutterRecipes().get(i);
            ItemStack result = ((StonecutterRecipe)recipe.value()).getResultItem((HolderLookup.Provider)Objects.requireNonNull(ClientPlatformUtil.getClientLevel()).registryAccess());
            int xx = this.getRecipeX(this.x, i);
            int row = i / 4;
            int yy = this.getRecipeY(this.y, row);
            if (yy < this.y + 9 - 18 || yy > this.y + 9 + 54 || mouseX < xx || mouseY < yy || mouseX >= xx + 16 || mouseY >= yy + 18) continue;
            graphics.renderTooltip(font, result, mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int clickedButton) {
        return this.scrollbar != null && this.scrollbar.mouseClicked(mouseX, mouseY, clickedButton) || this.clickedRecipe(mouseX, mouseY);
    }

    @Override
    public void mouseMoved(double mouseX, double mouseY) {
        if (this.scrollbar != null) {
            this.scrollbar.mouseMoved(mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return this.scrollbar != null && this.scrollbar.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double mouseZ, double delta) {
        return this.isOverStonecutterArea(mouseX, mouseY) && this.scrollbar != null && this.scrollbar.isActive() && this.scrollbar.mouseScrolled(mouseX, mouseY, mouseZ, delta);
    }

    @Override
    public void patternTypeChanged(PatternType newPatternType) {
        if (this.scrollbar != null) {
            this.scrollbar.visible = StonecutterPatternGridRenderer.isScrollbarVisible(this.menu);
        }
    }

    private static boolean isScrollbarVisible(PatternGridContainerMenu menu) {
        return menu.getPatternType() == PatternType.STONECUTTER;
    }

    private boolean clickedRecipe(double mouseX, double mouseY) {
        if (!this.isOverStonecutterArea(mouseX, mouseY)) {
            return false;
        }
        for (int i = 0; i < this.menu.getStonecutterRecipes().size(); ++i) {
            int xx = this.getRecipeX(this.x, i);
            int row = i / 4;
            int yy = this.getRecipeY(this.y, row);
            if (yy < this.y + 9 - 18 || yy > this.y + 9 + 54 || !(mouseX >= (double)xx) || !(mouseY >= (double)yy) || !(mouseX < (double)(xx + 16)) || !(mouseY < (double)(yy + 18))) continue;
            this.menu.setStonecutterSelectedRecipe(i);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
            return true;
        }
        return false;
    }

    private boolean isOverStonecutterArea(double mouseX, double mouseY) {
        return mouseX >= (double)(this.x + 40) && mouseX < (double)(this.x + 40 + 81) && mouseY > (double)(this.y + 8) && mouseY < (double)(this.y + 8 + 56);
    }

    private int getRecipeX(int insetX, int i) {
        return insetX + 40 + i % 4 * 16;
    }

    private int getRecipeY(int insetY, int row) {
        return insetY + 9 + row * 18 - (this.scrollbar != null ? (int)this.scrollbar.getOffset() : 0) * (this.scrollbar != null && this.scrollbar.isSmoothScrolling() ? 1 : 18);
    }
}

