/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.patterngrid;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridRenderer;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternType;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.ProcessingMatrixResourceSlot;
import com.refinedmods.refinedstorage.common.grid.AutocraftableResourceHint;
import com.refinedmods.refinedstorage.common.grid.screen.AbstractGridScreen;
import com.refinedmods.refinedstorage.common.support.ResourceSlotRendering;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.widget.ScrollbarWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

class ProcessingPatternGridRenderer
implements PatternGridRenderer {
    private static final ResourceLocation PROCESSING = IdentifierUtil.createIdentifier("pattern_grid/processing");
    private static final ResourceLocation PROCESSING_MATRIX = IdentifierUtil.createIdentifier("pattern_grid/processing_matrix");
    private static final int INDIVIDUAL_PROCESSING_MATRIX_SIZE = 54;
    private static final int PROCESSING_MATRIX_SLOT_SIZE = 18;
    private static final int PROCESSING_INSET_Y_PADDING = 9;
    private static final MutableComponent INPUTS = IdentifierUtil.createTranslation("gui", "pattern_grid.processing.inputs");
    private static final MutableComponent OUTPUTS = IdentifierUtil.createTranslation("gui", "pattern_grid.processing.outputs");
    private final PatternGridContainerMenu menu;
    private final int leftPos;
    private final int topPos;
    private final int x;
    private final int y;
    @Nullable
    private ScrollbarWidget scrollbar;

    ProcessingPatternGridRenderer(PatternGridContainerMenu menu, int leftPos, int topPos, int x, int y) {
        this.menu = menu;
        this.leftPos = leftPos;
        this.topPos = topPos;
        this.x = x;
        this.y = y;
    }

    @Override
    public void addWidgets(Consumer<AbstractWidget> widgets, Consumer<AbstractWidget> renderables) {
        this.scrollbar = this.createProcessingScrollbar();
        this.updateScrollbarMaxOffset();
        widgets.accept(this.scrollbar);
    }

    private void updateScrollbarMaxOffset() {
        if (this.scrollbar == null) {
            return;
        }
        int filledInputSlots = 0;
        int filledOutputSlots = 0;
        int lastFilledInputSlot = 0;
        int lastFilledOutputSlot = 0;
        for (int i = 0; i < this.menu.getResourceSlots().size(); ++i) {
            ResourceSlot resourceSlot = this.menu.getResourceSlots().get(i);
            if (resourceSlot.isEmpty() || !(resourceSlot instanceof ProcessingMatrixResourceSlot)) continue;
            ProcessingMatrixResourceSlot matrixSlot = (ProcessingMatrixResourceSlot)resourceSlot;
            if (matrixSlot.isInput()) {
                ++filledInputSlots;
                lastFilledInputSlot = i;
                continue;
            }
            ++filledOutputSlots;
            lastFilledOutputSlot = i - 81;
        }
        int maxFilledSlots = Math.max(filledInputSlots, filledOutputSlots);
        int maxFilledRows = Math.floorDiv(maxFilledSlots - 1, 3);
        int maxLastFilledSlot = Math.max(lastFilledInputSlot, lastFilledOutputSlot);
        int maxLastFilledRow = Math.floorDiv(maxLastFilledSlot, 3) - 2;
        int maxOffset = Math.max(maxFilledRows, maxLastFilledRow);
        int maxOffsetCorrected = this.scrollbar.isSmoothScrolling() ? maxOffset * 18 : maxOffset;
        this.scrollbar.setMaxOffset(maxOffsetCorrected);
        this.scrollbar.setEnabled(maxOffsetCorrected > 0);
    }

    private ScrollbarWidget createProcessingScrollbar() {
        ScrollbarWidget s = new ScrollbarWidget(this.x + 126, this.y + 14, ScrollbarWidget.Type.SMALL, 52);
        s.visible = ProcessingPatternGridRenderer.isScrollbarVisible(this.menu);
        s.setListener(offset -> this.onScrollbarChanged((int)offset));
        return s;
    }

    private void onScrollbarChanged(int offset) {
        int inputRow = 0;
        int outputRow = 0;
        int scrollbarOffset = this.scrollbar != null && this.scrollbar.isSmoothScrolling() ? offset : offset * 18;
        for (int i = 0; i < this.menu.getResourceSlots().size(); ++i) {
            ResourceSlot slot = this.menu.getResourceSlots().get(i);
            if (!(slot instanceof ProcessingMatrixResourceSlot)) continue;
            ProcessingMatrixResourceSlot matrixSlot = (ProcessingMatrixResourceSlot)slot;
            int row = matrixSlot.isInput() ? inputRow : outputRow;
            int slotY = this.y + 4 + 9 + 1 + row * 18 - scrollbarOffset - this.topPos;
            Platform.INSTANCE.setSlotY(this.menu.getResourceSlots().get(i), slotY);
            if ((i + 1) % 3 != 0) continue;
            if (matrixSlot.isInput()) {
                ++inputRow;
                continue;
            }
            ++outputRow;
        }
    }

    private static boolean isScrollbarVisible(PatternGridContainerMenu menu) {
        return menu.getPatternType() == PatternType.PROCESSING;
    }

    @Override
    public void tick() {
        this.updateScrollbarMaxOffset();
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.scrollbar != null) {
            this.scrollbar.render(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public int getClearButtonX() {
        return this.leftPos + 124;
    }

    @Override
    public int getClearButtonY() {
        return this.y + 4 + 9;
    }

    @Override
    public void renderBackground(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.blitSprite(PROCESSING, this.x + 4, this.y + 4 + 9, 130, 54);
        this.renderMatrix(graphics, this.x + 4 + 1, this.x + 4 + 1 + 52 + 1, mouseX, mouseY, true);
        this.renderMatrix(graphics, this.x + 4 + 54 + 2 + 1, this.x + 4 + 54 + 2 + 1 + 52 + 1, mouseX, mouseY, false);
    }

    private void renderMatrix(GuiGraphics graphics, int startX, int endX, int mouseX, int mouseY, boolean input) {
        int startY = this.y + 14;
        int endY = this.y + 14 + 52 + 1;
        graphics.enableScissor(startX, startY, endX, endY);
        this.renderMatrix(graphics, input);
        this.renderMatrixSlots(graphics, mouseX, mouseY, input);
        graphics.disableScissor();
    }

    private void renderMatrix(GuiGraphics graphics, boolean input) {
        int xx = this.x + 4 + (!input ? 56 : 0);
        int startY = this.y + 9 - 54;
        int endY = this.y + 9 + 54;
        int scrollbarOffset = this.scrollbar != null ? (int)this.scrollbar.getOffset() : 0;
        int scrollbarOffsetCorrected = this.scrollbar != null && this.scrollbar.isSmoothScrolling() ? scrollbarOffset : scrollbarOffset * 18;
        for (int i = 0; i < 9; ++i) {
            int yy = this.y + 13 + i * 54 - scrollbarOffsetCorrected;
            if (yy < startY || yy > endY) continue;
            graphics.blitSprite(PROCESSING_MATRIX, xx, yy, 54, 54);
        }
    }

    private void renderMatrixSlots(GuiGraphics graphics, int mouseX, int mouseY, boolean input) {
        for (ResourceSlot resourceSlot : this.menu.getResourceSlots()) {
            ProcessingMatrixResourceSlot matrixSlot;
            if (!resourceSlot.isActive() || !(resourceSlot instanceof ProcessingMatrixResourceSlot) || (matrixSlot = (ProcessingMatrixResourceSlot)resourceSlot).isInput() != input) continue;
            this.renderMatrixSlot(graphics, mouseX, mouseY, resourceSlot, matrixSlot);
        }
    }

    private void renderMatrixSlot(GuiGraphics graphics, int mouseX, int mouseY, ResourceSlot resourceSlot, ProcessingMatrixResourceSlot matrixSlot) {
        boolean hovering;
        if (matrixSlot.getResource() != null && this.menu.getRepository().isSticky(matrixSlot.getResource())) {
            AbstractGridScreen.renderSlotBackground(graphics, resourceSlot.x + this.leftPos, resourceSlot.y + this.topPos, false, AutocraftableResourceHint.AUTOCRAFTABLE.getColor());
        }
        ResourceSlotRendering.render(graphics, resourceSlot, this.leftPos, this.topPos);
        boolean bl = hovering = mouseX >= resourceSlot.x + this.leftPos && mouseX < resourceSlot.x + this.leftPos + 16 && mouseY >= resourceSlot.y + this.topPos && mouseY < resourceSlot.y + this.topPos + 16;
        if (hovering && this.canInteractWithResourceSlot(resourceSlot, mouseX, mouseY)) {
            AbstractContainerScreen.renderSlotHighlight((GuiGraphics)graphics, (int)(this.leftPos + resourceSlot.x), (int)(this.topPos + resourceSlot.y), (int)0);
        }
    }

    @Override
    public boolean canInteractWithResourceSlot(ResourceSlot resourceSlot, double mouseX, double mouseY) {
        ProcessingMatrixResourceSlot matrixSlot;
        int insetContentX = this.x + 4 + (resourceSlot instanceof ProcessingMatrixResourceSlot && !(matrixSlot = (ProcessingMatrixResourceSlot)resourceSlot).isInput() ? 56 : 0);
        int insetContentY = this.y + 4;
        return mouseX >= (double)insetContentX && mouseX < (double)(insetContentX + 54) && mouseY >= (double)(insetContentY + 9) && mouseY < (double)(insetContentY + 9 + 54);
    }

    @Override
    public void renderLabels(GuiGraphics graphics, Font font, int mouseX, int mouseY) {
        int xx = this.x - this.leftPos + 4;
        int yy = this.y - this.topPos - 1 + 4;
        graphics.drawString(font, (Component)INPUTS, xx, yy, 0x404040, false);
        graphics.drawString(font, (Component)OUTPUTS, xx + 56, yy, 0x404040, false);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int clickedButton) {
        return this.scrollbar != null && this.scrollbar.mouseClicked(mouseX, mouseY, clickedButton);
    }

    @Override
    public void mouseMoved(double mouseX, double mouseY) {
        if (this.scrollbar != null) {
            this.scrollbar.mouseMoved(mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return this.scrollbar != null && this.scrollbar.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double mouseZ, double delta) {
        if (!(mouseX >= (double)this.x && mouseX < (double)(this.x + 138) && mouseY > (double)this.y && mouseY < (double)(this.y + 71))) {
            return false;
        }
        return this.scrollbar != null && this.scrollbar.mouseScrolled(mouseX, mouseY, mouseZ, delta);
    }

    @Override
    public void patternTypeChanged(PatternType newPatternType) {
        if (this.scrollbar != null) {
            this.scrollbar.visible = ProcessingPatternGridRenderer.isScrollbarVisible(this.menu);
        }
    }
}

