/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.autocrafter;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSink;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSinkKey;
import com.refinedmods.refinedstorage.api.autocrafting.task.StepBehavior;
import com.refinedmods.refinedstorage.api.autocrafting.task.Task;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskImpl;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskSnapshot;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.autocrafting.PatternProvider;
import com.refinedmods.refinedstorage.api.network.autocrafting.PatternProviderExternalPatternSink;
import com.refinedmods.refinedstorage.api.network.impl.node.patternprovider.ExternalPatternSinkKeyProvider;
import com.refinedmods.refinedstorage.api.network.impl.node.patternprovider.PatternProviderListener;
import com.refinedmods.refinedstorage.api.network.impl.node.patternprovider.PatternProviderNetworkNode;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.autocrafting.PlatformPatternProviderExternalPatternSink;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.autocrafting.PatternInventory;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterConnectionStrategy;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterData;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterParentContainer;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.InWorldExternalPatternSinkKey;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.LockMode;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.LockModeSettings;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.TaskSnapshotPersistence;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.ExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutocrafterBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<PatternProviderNetworkNode>
implements ExtendedMenuProvider<AutocrafterData>,
BlockEntityWithDrops,
PatternInventory.Listener,
StepBehavior,
ExternalPatternSinkKeyProvider,
PatternProviderExternalPatternSink,
PatternProviderListener {
    static final int PATTERNS = 9;
    private static final Logger LOGGER = LoggerFactory.getLogger(AutocrafterBlockEntity.class);
    private static final int MAX_CHAINED_AUTOCRAFTERS = 8;
    private static final String TAG_UPGRADES = "upgr";
    private static final String TAG_PATTERNS = "patterns";
    private static final String TAG_LOCK_MODE = "lm";
    private static final String TAG_PRIORITY = "pri";
    private static final String TAG_TASKS = "tasks";
    private static final String TAG_VISIBLE_TO_THE_AUTOCRAFTER_MANAGER = "vaum";
    private static final String TAG_LOCKED = "locked";
    private static final String TAG_WAS_POWERED = "wp";
    private final PatternInventory patternContainer = new PatternInventory(9, () -> ((AutocrafterBlockEntity)this).getLevel());
    private final UpgradeContainer upgradeContainer;
    private LockMode lockMode = LockMode.NEVER;
    private boolean visibleToTheAutocrafterManager = true;
    private int ticks;
    private int steps = AutocrafterBlockEntity.getSteps(0);
    private int tickRate = AutocrafterBlockEntity.getTickRate(0);
    @Nullable
    private PlatformPatternProviderExternalPatternSink sink;
    @Nullable
    private ExternalPatternSinkKey sinkKey;
    private boolean wasPowered;
    private boolean locked;

    public AutocrafterBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.INSTANCE.getAutocrafter(), pos, state, new PatternProviderNetworkNode(Platform.INSTANCE.getConfig().getAutocrafter().getEnergyUsage(), 9));
        this.upgradeContainer = new UpgradeContainer((UpgradeDestination)UpgradeDestinations.AUTOCRAFTER, (c, upgradeEnergyUsage) -> {
            long baseEnergyUsage = Platform.INSTANCE.getConfig().getAutocrafter().getEnergyUsage();
            long patternEnergyUsage = this.patternContainer.getEnergyUsage();
            ((PatternProviderNetworkNode)this.mainNetworkNode).setEnergyUsage(baseEnergyUsage + patternEnergyUsage + upgradeEnergyUsage);
            int amountOfSpeedUpgrades = c.getAmount(Items.INSTANCE.getSpeedUpgrade());
            this.tickRate = AutocrafterBlockEntity.getTickRate(amountOfSpeedUpgrades);
            this.steps = AutocrafterBlockEntity.getSteps(amountOfSpeedUpgrades);
            this.setChanged();
        });
        this.patternContainer.addListener(container -> {
            long upgradeEnergyUsage = this.upgradeContainer.getEnergyUsage();
            long baseEnergyUsage = Platform.INSTANCE.getConfig().getAutocrafter().getEnergyUsage();
            long patternEnergyUsage = this.patternContainer.getEnergyUsage();
            ((PatternProviderNetworkNode)this.mainNetworkNode).setEnergyUsage(baseEnergyUsage + patternEnergyUsage + upgradeEnergyUsage);
            this.setChanged();
        });
        this.patternContainer.setListener(this);
        ((PatternProviderNetworkNode)this.mainNetworkNode).setStepBehavior(this);
        ((PatternProviderNetworkNode)this.mainNetworkNode).setSinkKeyProvider(this);
        ((PatternProviderNetworkNode)this.mainNetworkNode).setSink(this);
        ((PatternProviderNetworkNode)this.mainNetworkNode).setListener(this);
        ((PatternProviderNetworkNode)this.mainNetworkNode).onAddedIntoContainer(new AutocrafterParentContainer(this));
    }

    @Override
    protected InWorldNetworkNodeContainer createMainContainer(PatternProviderNetworkNode networkNode) {
        return new AutocrafterNetworkNodeContainer(this, networkNode, "main", new AutocrafterConnectionStrategy(() -> ((AutocrafterBlockEntity)this).getBlockState(), this.getBlockPos()));
    }

    FilteredContainer getPatternContainer() {
        return this.patternContainer;
    }

    UpgradeContainer getUpgradeContainer() {
        return this.upgradeContainer;
    }

    private boolean isPartOfChain() {
        return this.getChainingRoot() != this;
    }

    private boolean isHeadOfChain() {
        if (this.level == null || this.isPartOfChain()) {
            return false;
        }
        for (Direction direction : Direction.values()) {
            AutocrafterBlockEntity neighborAutocrafter;
            Direction neighborDirection;
            BlockEntity neighbor;
            BlockPos pos = this.getBlockPos().relative(direction);
            if (!this.level.isLoaded(pos) || !((neighbor = this.level.getBlockEntity(pos)) instanceof AutocrafterBlockEntity) || (neighborDirection = AbstractDirectionalBlock.tryExtractDirection((neighborAutocrafter = (AutocrafterBlockEntity)neighbor).getBlockState())) != direction.getOpposite()) continue;
            return true;
        }
        return false;
    }

    private AutocrafterBlockEntity getChainingRoot() {
        return this.getChainingRoot(0, this);
    }

    private AutocrafterBlockEntity getChainingRoot(int depth, AutocrafterBlockEntity origin) {
        Direction direction = AbstractDirectionalBlock.tryExtractDirection(this.getBlockState());
        if (this.level == null || direction == null || depth >= 8) {
            return origin;
        }
        BlockEntity neighbor = this.getConnectedMachine();
        if (!(neighbor instanceof AutocrafterBlockEntity)) {
            return this;
        }
        AutocrafterBlockEntity neighborCrafter = (AutocrafterBlockEntity)neighbor;
        return neighborCrafter.getChainingRoot(depth + 1, origin);
    }

    @Nullable
    private BlockEntity getConnectedMachine() {
        Direction direction = AbstractDirectionalBlock.tryExtractDirection(this.getBlockState());
        if (this.level == null || direction == null) {
            return null;
        }
        BlockPos neighborPos = this.getBlockPos().relative(direction);
        if (!this.level.isLoaded(neighborPos)) {
            return null;
        }
        return this.level.getBlockEntity(neighborPos);
    }

    public Component getName() {
        AutocrafterBlockEntity root = this.getChainingRoot();
        if (root == this) {
            return this.doGetName();
        }
        return root.getName();
    }

    private Component doGetName() {
        Component customName = this.getCustomName();
        if (customName != null) {
            return customName;
        }
        BlockEntity connectedMachine = this.getConnectedMachine();
        if (connectedMachine instanceof Nameable) {
            Nameable nameable = (Nameable)connectedMachine;
            if (!(connectedMachine instanceof AutocrafterBlockEntity)) {
                return nameable.getName();
            }
        }
        if (connectedMachine != null) {
            return connectedMachine.getBlockState().getBlock().getName();
        }
        return ContentNames.AUTOCRAFTER;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        return new AutocrafterContainerMenu(syncId, inventory, this);
    }

    @Override
    public AutocrafterData getMenuData() {
        return new AutocrafterData(this.isPartOfChain(), this.isHeadOfChain(), this.locked);
    }

    @Override
    public StreamEncoder<RegistryFriendlyByteBuf, AutocrafterData> getMenuCodec() {
        return AutocrafterData.STREAM_CODEC;
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(TAG_PATTERNS, (Tag)ContainerUtil.write((Container)this.patternContainer, provider));
        tag.put(TAG_UPGRADES, (Tag)ContainerUtil.write((Container)this.upgradeContainer, provider));
        tag.putBoolean(TAG_LOCKED, this.locked);
        tag.putBoolean(TAG_WAS_POWERED, this.wasPowered);
        ListTag tasks = new ListTag();
        for (Task task : ((PatternProviderNetworkNode)this.mainNetworkNode).getTasks()) {
            if (!(task instanceof TaskImpl)) continue;
            TaskImpl taskImpl = (TaskImpl)task;
            try {
                tasks.add((Object)TaskSnapshotPersistence.encodeSnapshot(taskImpl.createSnapshot()));
            }
            catch (Exception e) {
                LOGGER.error("Error while saving task {} {}", new Object[]{task.getResource(), task.getAmount(), e});
            }
        }
        tag.put(TAG_TASKS, (Tag)tasks);
    }

    @Override
    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
        tag.putInt(TAG_LOCK_MODE, LockModeSettings.getLockMode(this.lockMode));
        tag.putInt(TAG_PRIORITY, ((PatternProviderNetworkNode)this.mainNetworkNode).getPriority());
        tag.putBoolean(TAG_VISIBLE_TO_THE_AUTOCRAFTER_MANAGER, this.visibleToTheAutocrafterManager);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains(TAG_PATTERNS)) {
            ContainerUtil.read(tag.getCompound(TAG_PATTERNS), (Container)this.patternContainer, provider);
        }
        if (tag.contains(TAG_UPGRADES)) {
            ContainerUtil.read(tag.getCompound(TAG_UPGRADES), (Container)this.upgradeContainer, provider);
        }
        if (tag.contains(TAG_TASKS)) {
            ListTag tasks = tag.getList(TAG_TASKS, 10);
            for (int i = 0; i < tasks.size(); ++i) {
                CompoundTag taskTag = tasks.getCompound(i);
                try {
                    TaskSnapshot snapshot = TaskSnapshotPersistence.decodeSnapshot(taskTag);
                    ((PatternProviderNetworkNode)this.mainNetworkNode).addTask(new TaskImpl(snapshot));
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("Error while loading task, skipping", (Throwable)e);
                }
            }
        }
        if (tag.contains(TAG_LOCKED)) {
            this.locked = tag.getBoolean(TAG_LOCKED);
        }
        if (tag.contains(TAG_WAS_POWERED)) {
            this.wasPowered = tag.getBoolean(TAG_WAS_POWERED);
        }
        super.loadAdditional(tag, provider);
    }

    @Override
    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
        if (tag.contains(TAG_LOCK_MODE)) {
            this.lockMode = LockModeSettings.getLockMode(tag.getInt(TAG_LOCK_MODE));
        }
        if (tag.contains(TAG_PRIORITY)) {
            ((PatternProviderNetworkNode)this.mainNetworkNode).setPriority(tag.getInt(TAG_PRIORITY));
        }
        if (tag.contains(TAG_VISIBLE_TO_THE_AUTOCRAFTER_MANAGER)) {
            this.visibleToTheAutocrafterManager = tag.getBoolean(TAG_VISIBLE_TO_THE_AUTOCRAFTER_MANAGER);
        }
    }

    @Override
    protected boolean hasRedstoneMode() {
        return false;
    }

    @Override
    public List<ItemStack> getUpgrades() {
        return this.upgradeContainer.getUpgrades();
    }

    @Override
    public boolean addUpgrade(ItemStack upgradeStack) {
        return this.upgradeContainer.addUpgrade(upgradeStack);
    }

    @Override
    public NonNullList<ItemStack> getDrops() {
        NonNullList drops = NonNullList.create();
        drops.addAll(this.upgradeContainer.getDrops());
        for (int i = 0; i < this.patternContainer.getContainerSize(); ++i) {
            drops.add((Object)this.patternContainer.getItem(i));
        }
        return drops;
    }

    void setCustomName(String name) {
        if (this.isPartOfChain()) {
            return;
        }
        this.setCustomName((Component)(name.trim().isBlank() ? null : Component.literal((String)name)));
        this.setChanged();
    }

    LockMode getLockMode() {
        return this.lockMode;
    }

    void setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
        this.locked = false;
        this.wasPowered = false;
        this.setChanged();
    }

    int getPriority() {
        return ((PatternProviderNetworkNode)this.mainNetworkNode).getPriority();
    }

    void setPriority(int priority) {
        ((PatternProviderNetworkNode)this.mainNetworkNode).setPriority(priority);
        this.setChanged();
    }

    boolean isVisibleToTheAutocrafterManager() {
        return this.visibleToTheAutocrafterManager;
    }

    void setVisibleToTheAutocrafterManager(boolean visibleToTheAutocrafterManager) {
        this.visibleToTheAutocrafterManager = visibleToTheAutocrafterManager;
        this.setChanged();
    }

    @Override
    public void setLevel(Level level) {
        super.setLevel(level);
        if (level.isClientSide()) {
            return;
        }
        for (int i = 0; i < this.patternContainer.getContainerSize(); ++i) {
            this.patternChanged(i);
        }
    }

    @Override
    protected void initialize(ServerLevel level, Direction direction) {
        super.initialize(level, direction);
        Direction incomingDirection = direction.getOpposite();
        BlockPos sourcePosition = this.worldPosition.relative(direction);
        this.invalidateSinkKey();
        this.sink = RefinedStorageApi.INSTANCE.getPatternProviderExternalPatternSinkFactory().create(level, sourcePosition, incomingDirection);
    }

    @Override
    public void patternChanged(int slot) {
        if (this.level == null) {
            return;
        }
        Pattern pattern = RefinedStorageApi.INSTANCE.getPattern(this.patternContainer.getItem(slot), this.level).orElse(null);
        ((PatternProviderNetworkNode)this.mainNetworkNode).setPattern(slot, pattern);
    }

    @Override
    public void doWork() {
        super.doWork();
        if (((PatternProviderNetworkNode)this.mainNetworkNode).isActive()) {
            ++this.ticks;
        }
        this.updateLocked();
    }

    private void updateLocked() {
        boolean newLocked = this.calculateLocked();
        if (newLocked != this.locked) {
            this.setLocked(newLocked);
        }
    }

    private void setLocked(boolean locked) {
        this.locked = locked;
        this.setChanged();
    }

    boolean isLocked() {
        return this.locked;
    }

    private boolean calculateLocked() {
        if (this.level == null) {
            return false;
        }
        return switch (this.lockMode) {
            default -> throw new MatchException(null, null);
            case LockMode.NEVER -> false;
            case LockMode.LOCK_UNTIL_REDSTONE_PULSE_RECEIVED -> this.isLockedInPulseMode();
            case LockMode.LOCK_UNTIL_CONNECTED_MACHINE_IS_EMPTY -> {
                if (this.sink != null && !this.sink.isEmpty()) {
                    yield true;
                }
                yield false;
            }
            case LockMode.LOCK_UNTIL_ALL_OUTPUTS_ARE_RECEIVED -> this.locked;
            case LockMode.LOCK_UNTIL_HIGH_REDSTONE_SIGNAL -> {
                if (!this.level.hasNeighborSignal(this.worldPosition)) {
                    yield true;
                }
                yield false;
            }
            case LockMode.LOCK_UNTIL_LOW_REDSTONE_SIGNAL -> this.level.hasNeighborSignal(this.worldPosition);
        };
    }

    private boolean isLockedInPulseMode() {
        if (this.level != null && this.level.hasNeighborSignal(this.worldPosition)) {
            this.wasPowered = true;
            this.setChanged();
        } else if (this.wasPowered) {
            this.wasPowered = false;
            this.setChanged();
            return false;
        }
        return this.locked;
    }

    @Override
    public boolean canStep(Pattern pattern) {
        PatternProvider provider = this.lookupProvider(pattern);
        if (provider == null) {
            return false;
        }
        if (provider == this.mainNetworkNode) {
            return ((PatternProviderNetworkNode)this.mainNetworkNode).isActive() && this.ticks % this.tickRate == 0;
        }
        return provider.canStep(pattern);
    }

    @Override
    public int getSteps(Pattern pattern) {
        PatternProvider provider = this.lookupProvider(pattern);
        if (provider == null) {
            return 0;
        }
        if (provider == this.mainNetworkNode) {
            return this.steps;
        }
        return provider.getSteps(pattern);
    }

    private static int getSteps(int amountOfSpeedUpgrades) {
        return switch (amountOfSpeedUpgrades) {
            case 1 -> 2;
            case 2 -> 3;
            case 3 -> 4;
            case 4 -> 5;
            default -> 1;
        };
    }

    private static int getTickRate(int amountOfSpeedUpgrades) {
        return switch (amountOfSpeedUpgrades) {
            case 0 -> 10;
            case 1 -> 8;
            case 2 -> 6;
            case 3 -> 4;
            case 4 -> 2;
            default -> 0;
        };
    }

    @Nullable
    private PatternProvider lookupProvider(Pattern pattern) {
        Network network = ((PatternProviderNetworkNode)this.mainNetworkNode).getNetwork();
        if (network == null) {
            return null;
        }
        return network.getComponent(AutocraftingNetworkComponent.class).getProviderByPattern(pattern);
    }

    @Override
    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(BlockState oldBlockState, BlockState newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange(oldBlockState, newBlockState);
    }

    @Override
    @Nullable
    public ExternalPatternSinkKey getKey() {
        if (this.sinkKey == null) {
            this.tryUpdateSinkKey();
        }
        return this.sinkKey;
    }

    private void tryUpdateSinkKey() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Direction direction = AbstractDirectionalBlock.tryExtractDirection(this.getBlockState());
        if (direction == null) {
            return;
        }
        AutocrafterBlockEntity root = this.getChainingRoot();
        BlockEntity connectedMachine = root.getConnectedMachine();
        if (connectedMachine == null) {
            this.invalidateSinkKey();
            return;
        }
        BlockState connectedMachineState = connectedMachine.getBlockState();
        Player fakePlayer = this.getFakePlayer(serverLevel);
        ItemStack connectedMachineStack = Platform.INSTANCE.getBlockAsItemStack(connectedMachineState.getBlock(), connectedMachineState, direction.getOpposite(), (LevelReader)serverLevel, connectedMachine.getBlockPos(), fakePlayer);
        this.sinkKey = new InWorldExternalPatternSinkKey(this.getName().getString(), connectedMachineStack);
    }

    private void invalidateSinkKey() {
        this.sinkKey = null;
    }

    @Override
    public ExternalPatternSink.Result accept(Collection<ResourceAmount> resources, Action action) {
        AutocrafterBlockEntity root = this.getChainingRoot();
        if (root != this) {
            return root.accept(resources, action);
        }
        if (this.sink == null) {
            return ExternalPatternSink.Result.SKIPPED;
        }
        if (this.locked) {
            return ExternalPatternSink.Result.LOCKED;
        }
        ExternalPatternSink.Result result = this.sink.accept(resources, action);
        this.updateLockedAfterAccept(action, result);
        return result;
    }

    private void updateLockedAfterAccept(Action action, ExternalPatternSink.Result result) {
        if (result == ExternalPatternSink.Result.ACCEPTED && action == Action.EXECUTE && this.lockMode == LockMode.LOCK_UNTIL_CONNECTED_MACHINE_IS_EMPTY) {
            this.updateLocked();
        }
        if (result == ExternalPatternSink.Result.ACCEPTED && action == Action.EXECUTE && (this.lockMode == LockMode.LOCK_UNTIL_REDSTONE_PULSE_RECEIVED || this.lockMode == LockMode.LOCK_UNTIL_ALL_OUTPUTS_ARE_RECEIVED)) {
            this.setLocked(true);
        }
    }

    @Override
    public void receivedExternalIteration() {
        AutocrafterBlockEntity root = this.getChainingRoot();
        if (root != this) {
            root.receivedExternalIteration();
            return;
        }
        if (this.lockMode == LockMode.LOCK_UNTIL_ALL_OUTPUTS_ARE_RECEIVED && this.locked) {
            this.setLocked(false);
        }
    }
}

