/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.storage.tracked;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.core.CoreValidations;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.AbstractProxyStorage;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.tracked.InMemoryTrackedStorageRepository;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedResource;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedStorage;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedStorageRepository;
import java.util.Optional;
import java.util.function.LongSupplier;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="2.0.0-milestone.1.4")
public class TrackedStorageImpl
extends AbstractProxyStorage
implements TrackedStorage {
    private final TrackedStorageRepository repository;
    private final LongSupplier clock;

    public TrackedStorageImpl(Storage delegate, LongSupplier clock) {
        this(delegate, new InMemoryTrackedStorageRepository(), clock);
    }

    public TrackedStorageImpl(Storage delegate, TrackedStorageRepository repository, LongSupplier clock) {
        super(delegate);
        this.repository = repository;
        this.clock = clock;
    }

    @Override
    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        CoreValidations.validateNotNull(actor, "Source must not be null");
        long inserted = super.insert(resource, amount, action, actor);
        if (inserted > 0L && action == Action.EXECUTE) {
            this.repository.update(resource, actor, this.clock.getAsLong());
        }
        return inserted;
    }

    @Override
    public long extract(ResourceKey resource, long amount, Action action, Actor actor) {
        CoreValidations.validateNotNull(actor, "Source must not be null");
        long extracted = super.extract(resource, amount, action, actor);
        if (extracted > 0L && action == Action.EXECUTE) {
            this.repository.update(resource, actor, this.clock.getAsLong());
        }
        return extracted;
    }

    @Override
    public Optional<TrackedResource> findTrackedResourceByActorType(ResourceKey resource, Class<? extends Actor> actorType) {
        return this.repository.findTrackedResourceByActorType(resource, actorType);
    }
}

