/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.resource.filter;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import java.util.HashSet;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="2.0.0-milestone.1.0")
public class Filter {
    private final Set<ResourceKey> filters = new HashSet<ResourceKey>();
    private FilterMode mode = FilterMode.BLOCK;
    private UnaryOperator<ResourceKey> normalizer = value -> value;

    public FilterMode getMode() {
        return this.mode;
    }

    public void setNormalizer(UnaryOperator<ResourceKey> normalizer) {
        this.normalizer = normalizer;
    }

    public void setMode(FilterMode mode) {
        this.mode = mode;
    }

    public boolean isAllowed(ResourceKey resource) {
        ResourceKey normalized = (ResourceKey)this.normalizer.apply(resource);
        return switch (this.mode) {
            default -> throw new MatchException(null, null);
            case FilterMode.ALLOW -> this.filters.contains(normalized);
            case FilterMode.BLOCK -> !this.filters.contains(normalized);
        };
    }

    public void setFilters(Set<ResourceKey> filters) {
        this.filters.clear();
        this.filters.addAll(filters.stream().map(this.normalizer).collect(Collectors.toSet()));
    }
}

