/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.storage;

import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.api.network.node.container.NetworkNodeContainer;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.network.storage.StorageProvider;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.TrackedResourceAmount;
import com.refinedmods.refinedstorage.api.storage.root.RootStorageImpl;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageNetworkComponentImpl
extends RootStorageImpl
implements StorageNetworkComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageNetworkComponentImpl.class);

    public StorageNetworkComponentImpl(MutableResourceList list) {
        super(list);
    }

    @Override
    public void onContainerAdded(NetworkNodeContainer container) {
        NetworkNode networkNode = container.getNode();
        if (networkNode instanceof StorageProvider) {
            StorageProvider provider = (StorageProvider)((Object)networkNode);
            Storage storage = provider.getStorage();
            LOGGER.debug("Adding source {} from provider {}", (Object)storage, (Object)provider);
            this.addSource(storage);
        }
    }

    @Override
    public void onContainerRemoved(NetworkNodeContainer container) {
        NetworkNode networkNode = container.getNode();
        if (networkNode instanceof StorageProvider) {
            StorageProvider provider = (StorageProvider)((Object)networkNode);
            Storage storage = provider.getStorage();
            LOGGER.debug("Removing source {} of provider {}", (Object)storage, (Object)provider);
            this.removeSource(storage);
        }
    }

    @Override
    public List<TrackedResourceAmount> getResources(Class<? extends Actor> actorType) {
        return this.getAll().stream().map(resourceAmount -> new TrackedResourceAmount((ResourceAmount)resourceAmount, this.findTrackedResourceByActorType(resourceAmount.resource(), actorType).orElse(null))).toList();
    }

    @Override
    public boolean contains(Storage storage) {
        return this.storage.contains(storage);
    }
}

