/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.storage;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.core.CoreValidations;
import com.refinedmods.refinedstorage.api.network.impl.storage.StorageConfiguration;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.composite.CompositeAwareChild;
import com.refinedmods.refinedstorage.api.storage.composite.PriorityProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="2.0.0-milestone.2.4")
public abstract class AbstractConfiguredProxyStorage<S extends Storage>
implements CompositeAwareChild,
PriorityProvider {
    @Nullable
    private S delegate;
    private final StorageConfiguration config;

    protected AbstractConfiguredProxyStorage(StorageConfiguration config) {
        this.config = config;
    }

    protected AbstractConfiguredProxyStorage(StorageConfiguration config, S delegate) {
        this(config);
        this.delegate = delegate;
    }

    @Override
    public long extract(ResourceKey resource, long amount, Action action, Actor actor) {
        throw new UnsupportedOperationException("Immediate extract is not allowed");
    }

    @Override
    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        throw new UnsupportedOperationException("Immediate insert is not allowed");
    }

    @Override
    public CompositeAwareChild.Amount compositeInsert(ResourceKey resource, long amount, Action action, Actor actor) {
        if (this.delegate == null || this.config.getAccessMode().isExtractOnly() || !this.config.isActive() || !this.config.isAllowed(resource)) {
            return CompositeAwareChild.Amount.ZERO;
        }
        long inserted = this.delegate.insert(resource, amount, action, actor);
        if (this.config.isVoidExcess() && this.config.getFilterMode() == FilterMode.ALLOW && inserted < amount) {
            return new CompositeAwareChild.Amount(amount, inserted);
        }
        return new CompositeAwareChild.Amount(inserted, inserted);
    }

    @Override
    public CompositeAwareChild.Amount compositeExtract(ResourceKey resource, long amount, Action action, Actor actor) {
        if (this.delegate == null || this.config.getAccessMode().isInsertOnly() || !this.config.isActive()) {
            return CompositeAwareChild.Amount.ZERO;
        }
        long extracted = this.delegate.extract(resource, amount, action, actor);
        return new CompositeAwareChild.Amount(extracted, extracted);
    }

    @Override
    public Collection<ResourceAmount> getAll() {
        return this.delegate == null ? Collections.emptySet() : this.delegate.getAll();
    }

    @Override
    public long getStored() {
        return this.delegate == null ? 0L : this.delegate.getStored();
    }

    @Override
    public int getInsertPriority() {
        return this.config.getInsertPriority();
    }

    @Override
    public int getExtractPriority() {
        return this.config.getExtractPriority();
    }

    protected S getDelegate() {
        return (S)((Storage)Objects.requireNonNull(this.getUnsafeDelegate()));
    }

    @Nullable
    protected S getUnsafeDelegate() {
        return this.delegate;
    }

    public void setDelegate(S newDelegate) {
        CoreValidations.validateNull(this.delegate, "The current delegate is still set");
        CoreValidations.validateNotNull(newDelegate, "The new delegate cannot be null");
        this.delegate = newDelegate;
    }

    public final void tryClearDelegate() {
        if (this.delegate == null) {
            return;
        }
        this.clearDelegate();
    }

    public void clearDelegate() {
        CoreValidations.validateNotNull(this.delegate, "There is no delegate set, cannot clear");
        this.delegate = null;
    }
}

