/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.security;

import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.network.security.SecurityActor;
import com.refinedmods.refinedstorage.api.network.security.SecurityDecision;
import com.refinedmods.refinedstorage.api.network.security.SecurityDecisionProvider;
import com.refinedmods.refinedstorage.api.network.security.SecurityPolicy;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class SecurityDecisionProviderImpl
implements SecurityDecisionProvider {
    private final Map<SecurityActor, SecurityPolicy> policyByActor = new HashMap<SecurityActor, SecurityPolicy>();
    @Nullable
    private SecurityPolicy defaultPolicy;

    public SecurityDecisionProviderImpl setPolicy(SecurityActor actor, SecurityPolicy policy) {
        this.policyByActor.put(actor, policy);
        return this;
    }

    public SecurityDecisionProviderImpl setDefaultPolicy(@Nullable SecurityPolicy policy) {
        this.defaultPolicy = policy;
        return this;
    }

    public void clearPolicies() {
        this.policyByActor.clear();
    }

    @Override
    public SecurityDecision isAllowed(Permission permission, SecurityActor actor) {
        SecurityPolicy policy = this.policyByActor.get(actor);
        if (policy == null) {
            return SecurityDecision.PASS;
        }
        return SecurityDecisionProviderImpl.allowOrDeny(policy.isAllowed(permission));
    }

    @Override
    public SecurityDecision isAllowed(Permission permission) {
        if (this.defaultPolicy == null) {
            return SecurityDecision.PASS;
        }
        return SecurityDecisionProviderImpl.allowOrDeny(this.defaultPolicy.isAllowed(permission));
    }

    private static SecurityDecision allowOrDeny(boolean allowed) {
        return allowed ? SecurityDecision.ALLOW : SecurityDecision.DENY;
    }
}

