/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.node.relay;

import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.relay.RelayComponentType;
import com.refinedmods.refinedstorage.api.network.impl.node.relay.RelayOutputNetworkNode;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.api.storage.AccessMode;
import java.util.HashSet;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

public class RelayInputNetworkNode
extends AbstractNetworkNode {
    private final long energyUsage;
    private final Set<RelayComponentType<?>> componentTypes = new HashSet();
    @Nullable
    private RelayOutputNetworkNode outputNode;

    public RelayInputNetworkNode(long energyUsage) {
        this.energyUsage = energyUsage;
    }

    @Override
    public void setNetwork(@Nullable Network network) {
        super.setNetwork(network);
        this.updateComponents();
    }

    @Override
    protected void onActiveChanged(boolean newActive) {
        super.onActiveChanged(newActive);
        this.updateComponents();
    }

    public void setOutputNode(@Nullable RelayOutputNetworkNode outputNode) {
        this.outputNode = outputNode;
    }

    public void setComponentTypes(Set<RelayComponentType<?>> componentTypes) {
        this.componentTypes.clear();
        this.componentTypes.addAll(componentTypes);
        this.updateComponents();
    }

    public void updateComponentType(RelayComponentType<?> componentType, boolean enabled) {
        if (enabled) {
            this.componentTypes.add(componentType);
        } else {
            this.componentTypes.remove(componentType);
        }
        this.updateComponents();
    }

    private void updateComponents() {
        if (this.outputNode == null) {
            return;
        }
        boolean valid = this.network != null && this.isActive();
        for (RelayComponentType<?> componentType : RelayComponentType.ALL) {
            if (!this.componentTypes.contains(componentType) || !valid) {
                componentType.remove(this.outputNode);
                continue;
            }
            componentType.apply(this.network, this.outputNode);
        }
    }

    public void setAccessMode(AccessMode accessMode) {
        if (this.outputNode != null) {
            this.outputNode.setAccessMode(accessMode);
        }
    }

    public void setInsertPriority(int insertPriority) {
        if (this.outputNode != null) {
            this.outputNode.setInsertPriority(insertPriority);
        }
    }

    public void setExtractPriority(int extractPriority) {
        if (this.outputNode != null) {
            this.outputNode.setExtractPriority(extractPriority);
        }
    }

    public void setFilters(Set<ResourceKey> filters) {
        if (this.outputNode != null) {
            this.outputNode.setFilters(filters);
        }
    }

    public void setFilterMode(FilterMode filterMode) {
        if (this.outputNode != null) {
            this.outputNode.setFilterMode(filterMode);
        }
    }

    public void setFilterNormalizer(UnaryOperator<ResourceKey> normalizer) {
        if (this.outputNode != null) {
            this.outputNode.setFilterNormalizer(normalizer);
        }
    }

    public boolean hasComponentType(RelayComponentType<?> componentType) {
        return this.componentTypes.contains(componentType);
    }

    @Override
    public long getEnergyUsage() {
        return this.energyUsage;
    }
}

