/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.node.relay;

import com.refinedmods.refinedstorage.api.core.NullableType;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.energy.EnergyNetworkComponent;
import com.refinedmods.refinedstorage.api.network.impl.node.relay.RelayOutputNetworkNode;
import com.refinedmods.refinedstorage.api.network.security.SecurityNetworkComponent;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public class RelayComponentType<T> {
    public static final RelayComponentType<EnergyNetworkComponent> ENERGY = new RelayComponentType<EnergyNetworkComponent>(network -> network.getComponent(EnergyNetworkComponent.class), output -> output::setEnergyDelegate);
    public static final RelayComponentType<SecurityNetworkComponent> SECURITY = new RelayComponentType<SecurityNetworkComponent>(network -> network.getComponent(SecurityNetworkComponent.class), output -> output::setSecurityDelegate);
    public static final RelayComponentType<StorageNetworkComponent> STORAGE = new RelayComponentType<StorageNetworkComponent>(network -> network.getComponent(StorageNetworkComponent.class), output -> output::setStorageDelegate);
    public static final RelayComponentType<AutocraftingNetworkComponent> AUTOCRAFTING = new RelayComponentType<AutocraftingNetworkComponent>(network -> network.getComponent(AutocraftingNetworkComponent.class), output -> output::setAutocraftingDelegate);
    public static final Set<RelayComponentType<?>> ALL = Set.of(ENERGY, SECURITY, STORAGE, AUTOCRAFTING);
    private final Function<Network, T> componentProvider;
    private final Function<RelayOutputNetworkNode, Consumer<@NullableType T>> componentApplier;

    private RelayComponentType(Function<Network, T> componentProvider, Function<RelayOutputNetworkNode, Consumer<@NullableType T>> componentApplier) {
        this.componentProvider = componentProvider;
        this.componentApplier = componentApplier;
    }

    void apply(Network network, RelayOutputNetworkNode output) {
        T component = this.componentProvider.apply(network);
        this.componentApplier.apply(output).accept(component);
    }

    void remove(RelayOutputNetworkNode output) {
        this.componentApplier.apply(output).accept(null);
    }
}

