/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.node.exporter;

import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.network.node.NetworkNodeActor;
import com.refinedmods.refinedstorage.api.network.node.SchedulingMode;
import com.refinedmods.refinedstorage.api.network.node.exporter.ExporterTransferStrategy;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class ExporterNetworkNode
extends AbstractNetworkNode {
    private long energyUsage;
    private final Actor actor = new NetworkNodeActor(this);
    private final List<ExporterTask> tasks = new ArrayList<ExporterTask>();
    @Nullable
    private ExporterTransferStrategy transferStrategy;
    @Nullable
    private SchedulingMode schedulingMode;

    public ExporterNetworkNode(long energyUsage) {
        this.energyUsage = energyUsage;
    }

    public void setTransferStrategy(ExporterTransferStrategy transferStrategy) {
        this.transferStrategy = transferStrategy;
    }

    public void setSchedulingMode(@Nullable SchedulingMode schedulingMode) {
        this.schedulingMode = schedulingMode;
    }

    @Override
    public void doWork() {
        super.doWork();
        if (this.network == null || !this.isActive() || this.schedulingMode == null) {
            return;
        }
        this.schedulingMode.execute(this.tasks);
    }

    @Nullable
    public ExporterTransferStrategy.Result getLastResult(int filterIndex) {
        return this.tasks.get((int)filterIndex).lastResult;
    }

    public void setFilters(List<ResourceKey> filters) {
        ArrayList<ExporterTask> updatedTasks = new ArrayList<ExporterTask>();
        for (int i = 0; i < filters.size(); ++i) {
            ResourceKey filter = filters.get(i);
            ExporterTransferStrategy.Result lastResult = i < this.tasks.size() && this.tasks.get((int)i).filter.equals(filter) ? this.tasks.get((int)i).lastResult : null;
            ExporterTask task = new ExporterTask(filter, lastResult);
            updatedTasks.add(task);
        }
        this.tasks.clear();
        this.tasks.addAll(updatedTasks);
    }

    public void setEnergyUsage(long energyUsage) {
        this.energyUsage = energyUsage;
    }

    @Override
    public long getEnergyUsage() {
        return this.energyUsage;
    }

    class ExporterTask
    implements SchedulingMode.ScheduledTask {
        private final ResourceKey filter;
        @Nullable
        private ExporterTransferStrategy.Result lastResult;

        ExporterTask(@Nullable ResourceKey filter, ExporterTransferStrategy.Result lastResult) {
            this.filter = filter;
            this.lastResult = lastResult;
        }

        @Override
        public boolean run() {
            if (ExporterNetworkNode.this.transferStrategy == null || ExporterNetworkNode.this.network == null) {
                return false;
            }
            this.lastResult = ExporterNetworkNode.this.transferStrategy.transfer(this.filter, ExporterNetworkNode.this.actor, ExporterNetworkNode.this.network);
            return this.lastResult == ExporterTransferStrategy.Result.EXPORTED;
        }
    }
}

