/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.energy;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.core.CoreValidations;
import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;

public class EnergyStorageImpl
implements EnergyStorage {
    private final long capacity;
    private long stored;

    public EnergyStorageImpl(long capacity) {
        CoreValidations.validateNotNegative(capacity, "Capacity must be non-negative");
        this.capacity = capacity;
    }

    @Override
    public long getStored() {
        return this.stored;
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public long receive(long amount, Action action) {
        long spaceRemaining = this.capacity - this.stored;
        long maxReceive = Math.min(amount, spaceRemaining);
        if (maxReceive > 0L && action == Action.EXECUTE) {
            this.stored += maxReceive;
        }
        return maxReceive;
    }

    @Override
    public long extract(long amount, Action action) {
        long maxExtract = Math.min(this.stored, amount);
        if (maxExtract > 0L && action == Action.EXECUTE) {
            this.stored -= maxExtract;
        }
        return maxExtract;
    }
}

