/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.ui.api;

import com.google.gson.Gson;
import de.ambertation.wunderlib.utils.Version;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.LinkedList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import org.betterx.wover.config.api.client.ClientConfigs;
import org.betterx.wover.config.impl.CachedConfig;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.entrypoint.LibWoverUi;

public class VersionChecker
implements Runnable {
    private static final boolean TEST_UPDATE_SCREEN = false;
    private static final List<String> KNOWN_MODS = new LinkedList<String>();
    private static final List<ModVersion> NEW_VERSIONS = new LinkedList<ModVersion>();
    public static final int WAIT_FOR_DAYS = 5;
    private static final String BASE_URL = "https://wunderreich.ambertation.de/api/v1/versions/";
    private static Thread versionChecker;

    public static void startCheck(boolean isClient) {
        if (versionChecker == null && isClient) {
            VersionChecker checker = new VersionChecker();
            if (((Boolean)ClientConfigs.CLIENT.checkForNewVersions.get()).booleanValue() && ((Boolean)ClientConfigs.CLIENT.didPresentWelcomeScreen.get()).booleanValue()) {
                if (TEST_UPDATE_SCREEN) {
                    Gson gson = new Gson();
                    String fakeVersions = "{\n    \"mc\":\"1.21-rc.1\",\n    \"loader\":\"fabric\",\n    \"mods\":[\n      {\"n\":\"bclib\", \"v\":\"21.0.0\"},\n      {\"n\":\"wover\", \"v\":\"21.0.0\"},\n      {\"n\":\"betterend\", \"v\":\"21.0.0\"},\n      {\"n\":\"betternether\", \"v\":\"21.0.0\"},\n      {\"n\":\"wunderreich\", \"v\":\"21.0.0\"}\n    ]\n  }";
                    Versions json = (Versions)gson.fromJson(fakeVersions, Versions.class);
                    CachedConfig.INSTANCE.setLastVersionJson(fakeVersions);
                    CachedConfig.INSTANCE.save();
                    checker.processVersions(json);
                } else if (checker.needRecheck()) {
                    versionChecker = new Thread(checker);
                    versionChecker.start();
                } else {
                    String str = CachedConfig.INSTANCE.lastVersionJson();
                    if (str != null && str.trim().length() > 0) {
                        Gson gson = new Gson();
                        Versions json = (Versions)gson.fromJson(str, Versions.class);
                        checker.processVersions(json);
                    }
                }
            }
        }
    }

    public static void registerMod(ModCore modCore) {
        KNOWN_MODS.add(modCore.namespace);
    }

    private static void registerMod(String modId) {
        KNOWN_MODS.add(modId);
    }

    boolean needRecheck() {
        Instant lastCheck = CachedConfig.INSTANCE.lastCheckDate().plus(5L, ChronoUnit.DAYS);
        Instant now = Instant.now();
        return now.isAfter(lastCheck);
    }

    @Override
    public void run() {
        Gson gson = new Gson();
        ModCore modCore = ModCore.create((String)"minecraft");
        String minecraftVersion = modCore.getModVersion().toString().replace(".", "_");
        LibWoverUi.C.LOG.info("Check Versions for minecraft=" + minecraftVersion);
        try {
            String fileName = "mc_fabric_" + URLEncoder.encode(minecraftVersion, StandardCharsets.ISO_8859_1.toString()) + ".json";
            URL url = new URL(BASE_URL + fileName);
            try (InputStreamReader reader = new InputStreamReader(url.openStream());){
                Versions json = (Versions)gson.fromJson((Reader)reader, Versions.class);
                String str = gson.getAdapter(Versions.class).toJson((Object)json);
                CachedConfig.INSTANCE.setLastVersionJson(str);
                CachedConfig.INSTANCE.setLastCheckDate();
                CachedConfig.INSTANCE.save();
                this.processVersions(json);
            }
        }
        catch (UnsupportedEncodingException e) {
            LibWoverUi.C.LOG.error("Failed to encode URL during VersionCheck", (Exception)e);
            return;
        }
        catch (MalformedURLException e) {
            LibWoverUi.C.LOG.error("Invalid URL during VersionCheck", (Exception)e);
            return;
        }
        catch (IOException e) {
            LibWoverUi.C.LOG.error("I/O Error during VersionCheck", (Exception)e);
            return;
        }
    }

    private void processVersions(Versions json) {
        if (json != null) {
            LibWoverUi.C.LOG.info("Received Version Info for minecraft=" + json.mc + ", loader=" + json.loader);
            if (json.mods != null) {
                for (ModVersion mod : json.mods) {
                    if (!KNOWN_MODS.contains(mod.n) && FabricLoader.getInstance().getModContainer(mod.n).isPresent()) {
                        VersionChecker.registerMod(mod.n);
                    }
                    if (mod.n == null || mod.v == null || !KNOWN_MODS.contains(mod.n)) continue;
                    ModCore modCore = ModCore.create((String)mod.n);
                    Version installedVersion = modCore.getModVersion();
                    boolean isNew = TEST_UPDATE_SCREEN || installedVersion.isLessThan(mod.v) && !installedVersion.equals((Object)"0.0.0");
                    LibWoverUi.C.LOG.info(" - " + mod.n + ":" + mod.v + (isNew ? " (update available)" : ""));
                    if (!isNew) continue;
                    NEW_VERSIONS.add(mod);
                }
            }
        } else {
            LibWoverUi.C.LOG.warn("No valid Version Info");
        }
    }

    public static boolean isEmpty() {
        return NEW_VERSIONS.isEmpty();
    }

    public static void forEachUpdate(UpdateInfoProvider consumer) {
        for (ModVersion v : NEW_VERSIONS) {
            ModCore modCore = ModCore.create((String)v.n);
            String currrent = modCore.getModVersion().toString();
            consumer.send(v.n, currrent, v.v);
        }
    }

    public static class Versions {
        String mc;
        String loader;
        List<ModVersion> mods;

        public String toString() {
            return "Versions{mc='" + this.mc + "', loader='" + this.loader + "', mods=" + String.valueOf(this.mods) + "}";
        }
    }

    public static class ModVersion {
        String n;
        String v;

        public String toString() {
            return this.n + ":" + this.v;
        }
    }

    @FunctionalInterface
    public static interface UpdateInfoProvider {
        public void send(String var1, String var2, String var3);
    }
}

