/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easypiglins.blocks.tileentity;

import de.maxhenkel.easypiglins.blocks.tileentity.FakeWorldTileentity;
import de.maxhenkel.easypiglins.datacomponents.PiglinData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class PiglinTileentity
extends FakeWorldTileentity {
    private ItemStack piglin = ItemStack.EMPTY;
    private Piglin piglinEntity;

    public PiglinTileentity(BlockEntityType<?> type, BlockState defaultState, BlockPos pos, BlockState state) {
        super(type, defaultState, pos, state);
    }

    public ItemStack getPiglin() {
        if (this.piglinEntity != null) {
            PiglinData.applyToItem(this.piglin, this.piglinEntity);
        }
        return this.piglin;
    }

    public boolean hasPiglin() {
        return !this.piglin.isEmpty();
    }

    public Piglin getPiglinEntity() {
        if (this.piglinEntity == null && !this.piglin.isEmpty()) {
            this.piglinEntity = PiglinData.createPiglin(this.piglin, this.level);
        }
        return this.piglinEntity;
    }

    public void setPiglin(ItemStack piglin) {
        this.piglin = piglin;
        if (piglin.isEmpty()) {
            this.piglinEntity = null;
        } else {
            this.piglinEntity = PiglinData.createPiglin(piglin, this.level);
            this.onAddPiglin(this.piglinEntity);
        }
        this.setChanged();
        this.sync();
    }

    protected void onAddPiglin(Piglin piglin) {
    }

    public ItemStack removePiglin() {
        ItemStack v = this.getPiglin();
        this.setPiglin(ItemStack.EMPTY);
        return v;
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        if (this.hasPiglin()) {
            compound.put("Piglin", this.getPiglin().saveOptional(provider));
        }
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        if (compound.contains("Piglin")) {
            CompoundTag comp = compound.getCompound("Piglin");
            this.piglin = PiglinData.convert(provider, comp);
            this.piglinEntity = null;
        } else {
            this.removePiglin();
        }
        super.loadAdditional(compound, provider);
    }
}

