/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.vanilla;

import de.ambertation.wunderlib.ui.ColorHelper;
import de.ambertation.wunderlib.ui.layout.components.HorizontalStack;
import de.ambertation.wunderlib.ui.layout.components.LayoutComponent;
import de.ambertation.wunderlib.ui.layout.components.Panel;
import de.ambertation.wunderlib.ui.layout.components.Text;
import de.ambertation.wunderlib.ui.layout.components.VerticalStack;
import de.ambertation.wunderlib.ui.layout.values.Value;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class LayoutScreen
extends class_437 {
    protected static final Runnable EMPTY_SCREEN = () -> class_310.method_1551().method_1507(null);
    protected final int topPadding;
    protected final int bottomPadding;
    protected final int sidePadding;
    protected final int titleSpacing;
    private OverlayProvider overlayProvider = null;
    private Panel currentOverlay = null;
    @Nullable
    protected Panel main;
    @Nullable
    public final Runnable onClose;

    public LayoutScreen(class_2561 component) {
        this(EMPTY_SCREEN, component);
    }

    public LayoutScreen(@Nullable class_437 parent, class_2561 component) {
        this(LayoutScreen.setScreenOnClose(parent), component);
    }

    public LayoutScreen(@Nullable class_437 parent, class_2561 component, int topPadding, int bottomPadding, int sidePadding) {
        this(LayoutScreen.setScreenOnClose(parent), component, topPadding, bottomPadding, sidePadding);
    }

    public LayoutScreen(@Nullable Runnable onClose, class_2561 component) {
        this(onClose, component, 20, 10, 20, 15);
    }

    public LayoutScreen(@Nullable Runnable onClose, class_2561 component, int topPadding, int bottomPadding, int sidePadding) {
        this(onClose, component, topPadding, bottomPadding, sidePadding, 15);
    }

    public LayoutScreen(@Nullable Runnable onClose, class_2561 component, int topPadding, int bottomPadding, int sidePadding, int titleSpacing) {
        super(component);
        this.onClose = onClose;
        this.topPadding = topPadding;
        this.bottomPadding = bottomPadding;
        this.sidePadding = sidePadding;
        this.titleSpacing = titleSpacing;
    }

    protected abstract LayoutComponent<?, ?> initContent();

    protected void openLink(String uri) {
        class_407 cls = new class_407(bl -> {
            if (bl) {
                class_156.method_668().method_670(uri);
            }
            this.field_22787.method_1507((class_437)this);
        }, uri, true);
        class_310.method_1551().method_1507((class_437)cls);
    }

    protected final void method_25426() {
        super.method_25426();
        this.main = new Panel(this, this.field_22789, this.field_22790);
        this.main.setChild(this.createScreen(this.initContent()));
        this.main.calculateLayout();
        this.method_37063((class_364)this.main);
    }

    protected LayoutComponent<?, ?> createTitle() {
        Text text = (Text)((Text)new Text(LayoutScreen.fit(), LayoutScreen.fit(), this.field_22785).centerHorizontal()).setColor(ColorHelper.WHITE).setDebugName("title");
        return text;
    }

    protected LayoutComponent<?, ?> createScreen(LayoutComponent<?, ?> content) {
        VerticalStack rows = (VerticalStack)new VerticalStack(LayoutScreen.fill(), LayoutScreen.fill()).setDebugName("title stack");
        if (this.topPadding > 0) {
            rows.addSpacer(this.topPadding);
        }
        rows.add((LayoutComponent)this.createTitle());
        rows.addSpacer(this.titleSpacing);
        rows.add((LayoutComponent)content);
        if (this.bottomPadding > 0) {
            rows.addSpacer(this.bottomPadding);
        }
        if (this.sidePadding <= 0) {
            return rows;
        }
        HorizontalStack cols = (HorizontalStack)new HorizontalStack(LayoutScreen.fill(), LayoutScreen.fill()).setDebugName("padded side");
        cols.addSpacer(this.sidePadding);
        cols.add((LayoutComponent)rows);
        cols.addSpacer(this.sidePadding);
        return cols;
    }

    public void renderBackgroundLayer(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        this.method_25420(guiGraphics, mouseX, mouseY, delta);
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        this.renderBackgroundLayer(guiGraphics, i, j, f);
        super.method_25394(guiGraphics, i, j, f);
    }

    protected static Runnable setScreenOnClose(class_437 screen) {
        if (screen == null) {
            return EMPTY_SCREEN;
        }
        return () -> class_310.method_1551().method_1507(screen);
    }

    protected final void closeScreen() {
        this.method_25419();
    }

    public void method_25419() {
        if (this.onClose != null) {
            this.onClose.run();
        } else {
            class_310.method_1551().method_1507(null);
        }
    }

    public boolean method_25421() {
        return true;
    }

    public static Value fit() {
        return Value.fit();
    }

    public static Value fitOrFill() {
        return Value.fitOrFill();
    }

    public static Value fill() {
        return Value.fill();
    }

    public static Value fixed(int size) {
        return Value.fixed(size);
    }

    public static Value relative(double percentage) {
        return Value.relative(percentage);
    }

    public static class_5250 translatable(String key) {
        return class_2561.method_43471((String)key);
    }

    public static class_5250 literal(String content) {
        return class_2561.method_43470((String)content);
    }

    public void setOverlayProvider(OverlayProvider newOverlay) {
        if (this.overlayProvider != null) {
            this.overlayProvider.willRemoveOverlay();
        }
        if (this.currentOverlay != null) {
            this.method_37066((class_364)this.currentOverlay);
            this.currentOverlay = null;
        }
        this.overlayProvider = newOverlay;
        if (this.overlayProvider != null) {
            this.currentOverlay = this.overlayProvider.getOverlay();
            this.method_37063((class_364)this.currentOverlay);
        }
    }

    public static interface OverlayProvider {
        @NotNull
        public Panel getOverlay();

        public void willRemoveOverlay();
    }
}

