/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.layout.components;

import de.ambertation.wunderlib.ui.layout.components.Button;
import de.ambertation.wunderlib.ui.layout.components.Container;
import de.ambertation.wunderlib.ui.layout.components.LayoutComponent;
import de.ambertation.wunderlib.ui.layout.components.Panel;
import de.ambertation.wunderlib.ui.layout.components.Text;
import de.ambertation.wunderlib.ui.layout.components.VerticalScroll;
import de.ambertation.wunderlib.ui.layout.components.VerticalStack;
import de.ambertation.wunderlib.ui.layout.values.Value;
import de.ambertation.wunderlib.ui.vanilla.LayoutScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DropDown<T>
extends Button {
    private static final class_2561 EMPTY = class_2561.method_43470((String)"---");
    Panel panel;
    private final VerticalStack items;
    private class_2561 valueComponent;
    private T currentValue;
    private final List<ValueItem<T>> values = new ArrayList<ValueItem<T>>(4);
    private OnChange<T> onChange;

    public DropDown(Value width, Value height) {
        super(width, height, EMPTY);
        this.onPress = this::onPress;
        this.items = new VerticalStack(Value.fit(), Value.fit());
    }

    public void close() {
        if (this.panel != null) {
            this.panel = null;
            this.parentPanel.parentScreen.setOverlayProvider(null);
            this.didClose();
        }
    }

    private void didClose() {
        this.onBoundsChanged();
    }

    private void playDownSound(class_1144 soundManager) {
        soundManager.method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
    }

    public DropDown<T> onChange(OnChange<T> onChange) {
        this.onChange = onChange;
        return this;
    }

    public DropDown<T> addOption(class_2561 title, T value) {
        return this.addOption(title, value, null);
    }

    public DropDown<T> addOption(class_2561 title, final T value, @Nullable Consumer<T> callback) {
        Text component = new Text(Value.fit(), Value.fixed(20), title){

            public boolean method_25402(double d, double e, int i) {
                if (this.relativeBounds.contains(d, e)) {
                    DropDown.this.playDownSound(class_310.method_1551().method_1483());
                    DropDown.this.select(value, true);
                    DropDown.this.close();
                    return true;
                }
                return false;
            }
        };
        ValueItem<T> item = new ValueItem<T>(title, value, component, callback);
        this.values.add(item);
        this.items.add((LayoutComponent)item.component);
        return this;
    }

    public boolean selectFirst() {
        if (this.values.isEmpty()) {
            return false;
        }
        return this.select(this.values.get((int)0).value);
    }

    public boolean select(T value) {
        return this.select(value, true);
    }

    public boolean select(T value, boolean fireEvent) {
        for (ValueItem<T> item : this.values) {
            if (!item.value.equals(value)) continue;
            this.valueComponent = item.title;
            if (this.currentValue != value) {
                this.currentValue = value;
                if (fireEvent && item.callback != null) {
                    item.callback.accept(item.value);
                }
                if (fireEvent && this.onChange != null) {
                    this.onChange.now(this, value);
                }
            }
            return true;
        }
        this.valueComponent = null;
        if (this.currentValue != null) {
            this.currentValue = null;
            if (fireEvent && this.onChange != null) {
                this.onChange.now(this, null);
            }
        }
        return false;
    }

    public T selectedOption() {
        return this.currentValue;
    }

    @Override
    protected class_2561 contentComponent() {
        if (this.valueComponent == null) {
            return EMPTY;
        }
        return this.valueComponent;
    }

    private void onPress(Button button) {
        if (this.panel == null) {
            boolean PADDING = true;
            this.panel = new Panel(this.parentPanel.parentScreen){

                @Override
                public boolean method_25402(double d, double e, int i) {
                    if (!super.method_25402(d, e, i)) {
                        DropDown.this.close();
                    }
                    return true;
                }
            };
            Container backdrop = new Container(Value.fill(), Value.fill());
            backdrop.setBackgroundColor(0x77000000);
            this.panel.setChild(backdrop).setZIndex(this.parentPanel.getZIndex() + 50.0f);
            this.items.calculateLayoutInParent(this.parentPanel);
            int height = this.items.getScreenBounds().height;
            if (this.screenBounds.bottom() + height > this.parentPanel.parentScreen.field_22790) {
                height = Math.max(30, this.parentPanel.parentScreen.field_22790 - this.screenBounds.bottom() - 3);
            }
            Container contentContainer = Container.create(Value.fit(), Value.fixed(height + 2), VerticalScroll.create(this.items));
            contentContainer.setOutlineColor(-11184794);
            contentContainer.setBackgroundColor(-1761607680);
            contentContainer.setPadding(5, 1, 1, 1);
            backdrop.addChild(this.screenBounds.left + 10, this.screenBounds.bottom(), contentContainer);
            this.panel.calculateLayout();
            this.parentPanel.parentScreen.setOverlayProvider(new LayoutScreen.OverlayProvider(){

                @Override
                @NotNull
                public Panel getOverlay() {
                    return DropDown.this.panel;
                }

                @Override
                public void willRemoveOverlay() {
                    DropDown.this.parentPanel.setInputEnabled(true);
                    DropDown.this.panel = null;
                    DropDown.this.didClose();
                }
            });
            this.parentPanel.setInputEnabled(false);
        }
    }

    public static interface OnChange<T> {
        public void now(DropDown<T> var1, T var2);
    }

    private record ValueItem<T>(class_2561 title, T value, LayoutComponent<?, ?> component, Consumer<T> callback) {
    }
}

